/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.energiser;

import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.antarcticgardens.newage.CreateNewAge;
import org.antarcticgardens.newage.content.energiser.EnergiserBlock;
import org.antarcticgardens.newage.content.energiser.EnergiserBlockEntity;
import org.antarcticgardens.newage.content.energiser.EnergisingRecipe;
import org.joml.Math;

public class EnergiserBehaviour
extends BeltProcessingBehaviour {
    protected int tier;
    protected EnergiserBlockEntity be;
    public EnergisingRecipe currentRecipe;
    public long charged;
    public long needed;
    private boolean shouldCreateParticles = false;
    public long sinceUpdate = 0L;

    public EnergiserBehaviour(EnergiserBlockEntity be) {
        super((SmartBlockEntity)be);
        this.whenItemEnters(this::itemEnter);
        this.whileItemHeld(this::itemHeld);
        this.be = be;
    }

    public EnergisingRecipe getRecipe(ItemStack stack) {
        if (this.be.m_58904_() == null) {
            return null;
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.getWorld(), (ItemStack)stack, (RecipeType)CreateNewAge.ENERGISING_RECIPE_TYPE.getType(), EnergisingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return (EnergisingRecipe)((Object)assemblyRecipe.get());
        }
        List recipes = this.be.m_58904_().m_7465_().m_44013_(CreateNewAge.ENERGISING_RECIPE_TYPE.getType());
        for (EnergisingRecipe recipe : recipes) {
            if (!recipe.test(stack)) continue;
            return recipe;
        }
        return null;
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.charged = nbt.m_128454_("charged");
        this.needed = nbt.m_128454_("needed");
        this.shouldCreateParticles = nbt.m_128471_("shouldCreateParticles");
        super.read(nbt, clientPacket);
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128356_("charged", this.charged);
        nbt.m_128356_("needed", this.needed);
        nbt.m_128379_("shouldCreateParticles", this.shouldCreateParticles);
        if (clientPacket) {
            this.shouldCreateParticles = false;
        }
        super.write(nbt, clientPacket);
    }

    public void tick() {
        super.tick();
        if (this.be.m_58904_() == null) {
            return;
        }
        if (!this.be.m_58904_().m_5776_() && this.needed > 0L) {
            --this.sinceUpdate;
            if (this.sinceUpdate <= 0L) {
                this.needed = 0L;
                this.be.getEnergyStorage().internalInsert(this.charged, false);
                this.charged = 0L;
                this.currentRecipe = null;
                this.blockEntity.sendData();
            }
        }
        this.be.lastCharged = -1L;
        if (this.needed > 0L) {
            this.be.lastCharged = this.be.energy.internalExtract((long)Math.min((float)((long)EnergiserBlock.getStrength(this.tier) * (long)Math.abs((double)((double)this.be.getSpeed() * 0.1))), (float)(this.needed - this.charged)), false);
            this.charged += this.be.lastCharged;
        }
        if (this.be.m_58904_().m_5776_()) {
            this.be.size -= 0.15f;
            this.be.size = Math.clamp((float)0.0f, (float)1.0f, (float)this.be.size);
            if (this.needed > 0L && this.charged > 0L) {
                this.be.size = (float)Math.lerp((double)this.be.size, (double)((float)this.charged / (float)this.needed), (double)0.6);
            } else if (this.shouldCreateParticles) {
                this.shouldCreateParticles = false;
                RandomSource rand = this.be.m_58904_().m_213780_();
                for (int i = 0; i < 6; ++i) {
                    this.be.m_58904_().m_6493_((ParticleOptions)ParticleTypes.f_175827_, false, (double)this.be.m_58899_().m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.4, (double)this.be.m_58899_().m_123342_() - 1.4 + ((double)rand.m_188501_() - 0.5) * 0.4, (double)this.be.m_58899_().m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.4, 0.0, 0.5, 0.0);
                }
                this.be.m_58904_().m_7785_((double)this.be.m_58899_().m_123341_() + 0.5, (double)this.be.m_58899_().m_123342_() - 1.4, (double)this.be.m_58899_().m_123343_() + 0.5, SoundEvents.f_11897_, SoundSource.BLOCKS, 0.3f, 2.0f, true);
            }
        }
    }

    private BeltProcessingBehaviour.ProcessingResult itemHeld(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour handler) {
        if (this.currentRecipe == null) {
            this.currentRecipe = this.getRecipe(transportedItemStack.stack);
        }
        if (this.be.getSpeed() == 0.0f || this.currentRecipe == null || this.be.m_58904_() == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        int count = transportedItemStack.stack.m_41613_();
        this.needed = (long)count * (long)this.currentRecipe.energyNeeded;
        this.sinceUpdate = 10L;
        if (this.charged >= this.needed) {
            List out = this.currentRecipe.rollResults().stream().map(stack -> {
                TransportedItemStack copy = transportedItemStack.copy();
                boolean centered = BeltHelper.isItemUpright((ItemStack)stack);
                stack.m_41764_(stack.m_41613_() * count);
                copy.stack = stack;
                copy.angle = centered ? 180 : this.be.m_58904_().m_213780_().m_188503_(360);
                return copy;
            }).collect(Collectors.toList());
            if (this.charged > this.needed) {
                this.be.getEnergyStorage().insertEnergy(this.charged - this.needed, false);
            }
            this.charged = 0L;
            this.needed = 0L;
            if (out.isEmpty()) {
                handler.handleProcessingOnItem(transportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            } else {
                handler.handleProcessingOnItem(transportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(out));
            }
            this.shouldCreateParticles = true;
            this.blockEntity.sendData();
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private BeltProcessingBehaviour.ProcessingResult itemEnter(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour transportedItemStackHandlerBehaviour) {
        if (this.be.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        this.currentRecipe = this.getRecipe(transportedItemStack.stack);
        if (this.currentRecipe == null || this.currentRecipe.m_7527_().size() > 1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

