/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.generation.generatorcoil;

import com.google.common.collect.Lists;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.generation.magnets.IMagneticBlock;
import org.antarcticgardens.newage.tools.RelativeBlockPos;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class GeneratorCoilBlockEntity
extends KineticBlockEntity {
    private final List<BlockPos> magnetPositions;
    private float lastStress = 0.0f;
    private int generatedEnergy = 0;
    private float plainStress;

    public GeneratorCoilBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        RelativeBlockPos relativePosition = new RelativeBlockPos(this.f_58858_, (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS));
        this.magnetPositions = Lists.newArrayList((Object[])new BlockPos[]{relativePosition.up(2).getPos(), relativePosition.up(2).right(1).getPos(), relativePosition.up(2).left(1).getPos(), relativePosition.down(2).getPos(), relativePosition.down(2).right(1).getPos(), relativePosition.down(2).left(1).getPos(), relativePosition.right(2).getPos(), relativePosition.right(2).up(1).getPos(), relativePosition.right(2).down(1).getPos(), relativePosition.left(2).getPos(), relativePosition.left(2).up(1).getPos(), relativePosition.left(2).down(1).getPos()});
        this.setLazyTickRate(20);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(1.0);
    }

    public float calculateStressApplied() {
        float stress = this.plainStress = super.calculateStressApplied();
        for (BlockPos pos : this.magnetPositions) {
            Block block = this.f_58857_.m_8055_(pos).m_60734_();
            if (!(block instanceof IMagneticBlock)) continue;
            IMagneticBlock magneticBlock = (IMagneticBlock)block;
            stress += magneticBlock.getStrength();
        }
        this.lastStressApplied = stress;
        return stress;
    }

    public void tick() {
        super.tick();
        this.generatedEnergy = (int)((double)((this.lastStressApplied - this.plainStress) * Math.abs(this.getSpeed())) * (Double)NewAgeConfig.getCommon().suToEnergy.get());
    }

    public void lazyTick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        float stress = this.calculateStressApplied();
        KineticNetwork network = this.getOrCreateNetwork();
        if (network != null && this.lastStress != stress) {
            network.updateStressFor((KineticBlockEntity)this, stress);
            network.updateStress();
            this.sendData();
            this.lastStress = stress;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.efficiency", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.percent", (Object[])new Object[]{StringFormattingTool.formatPercentFloat((this.lastStressApplied - this.plainStress) / this.lastStressApplied)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public int takeGeneratedEnergy() {
        int energy = this.generatedEnergy;
        this.generatedEnergy = 0;
        return energy;
    }
}

