/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.heater;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.newage.NewAgeBlockEntityTypes;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.heat.heater.HeaterBlockEntity;
import org.antarcticgardens.newage.content.heat.heatpipe.HeatPipeBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaterBlock
extends Block
implements EntityBlock,
IWrenchable {
    public static final IntegerProperty STRENGTH = IntegerProperty.m_61631_((String)"heat_strength", (int)0, (int)3);

    public HeaterBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Integer)state.m_61143_((Property)STRENGTH) * 2));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STRENGTH});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return NewAgeBlockEntityTypes.HEATER.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        int on = HeatPipeBlock.massPipe++;
        if (HeatPipeBlock.massPipe >= 20) {
            HeatPipeBlock.massPipe = 0;
        }
        return (world, blockPos, blockState, sel) -> {
            HeaterBlockEntity self;
            if ((world.m_46467_() + (long)on) % 20L != 0L || !(sel instanceof HeaterBlockEntity) || (self = (HeaterBlockEntity)sel).m_58904_() == null) {
                return;
            }
            HeatBlockEntity.transferAround(self);
            double multiplier = (Double)NewAgeConfig.getCommon().overheatingMultiplier.get();
            if (multiplier > 0.0 && (double)self.heat > 9000.0 * (Double)NewAgeConfig.getCommon().overheatingMultiplier.get()) {
                self.m_58904_().m_7731_(self.m_58899_(), Blocks.f_49991_.m_49966_(), 3);
            } else if (self.heat > 400.0f) {
                self.heat -= 400.0f;
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(3)), 3);
            } else if (self.heat > 100.0f) {
                self.heat -= 100.0f;
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(2)), 3);
            } else if (self.heat > 50.0f) {
                self.heat -= 50.0f;
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(1)), 3);
            } else {
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(0)), 3);
            }
            self.m_6596_();
        };
    }
}

