/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.newage.content.motors.MotorBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotorBlock
extends DirectionalKineticBlock
implements IRotate,
IBE<MotorBlockEntity> {
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final BlockEntityEntry<MotorBlockEntity> entry;
    private final long capacity;
    private final float stressGenerated;
    private final float maxSpeed;

    public MotorBlock(BlockBehaviour.Properties properties, BlockEntityEntry<MotorBlockEntity> entry, long capacity, float stressGenerated, float maxSpeed) {
        super(properties);
        this.entry = entry;
        this.capacity = capacity;
        this.stressGenerated = stressGenerated;
        this.maxSpeed = maxSpeed;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Lang.translate((String)"tooltip.create_new_age.generates", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)Lang.text((String)" ").add(Lang.number((double)this.stressGenerated).text(" ").translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA)).component());
        tooltip.add((Component)Lang.translate((String)"tooltip.create_new_age.stores", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)Lang.text((String)" ").translate("tooltip.create_new_age.energy", new Object[]{StringFormattingTool.formatLong(this.capacity)}).style(ChatFormatting.AQUA).component());
        tooltip.add((Component)Lang.translate((String)"tooltip.create_new_age.max_speed", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)Lang.text((String)" ").translate("tooltip.create_new_age.rpm", new Object[]{(int)this.maxSpeed}).style(ChatFormatting.AQUA).component());
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.NONE;
    }

    public void m_6786_(LevelAccessor arg, BlockPos arg2, BlockState arg3) {
        BlockEntity entity;
        if (arg3.m_155947_() && (entity = arg.m_7702_(arg2)) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.speedBehavior.value = 0;
            en.updateGeneratedRotation();
        }
        super.m_6786_(arg, arg2, arg3);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction f = super.getPreferredFacing(context);
        return f == null ? null : f.m_122424_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.m_61143_((Property)FACING);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
            }
            state.m_222967_((ServerLevel)world, pos, ItemStack.f_41583_, true);
            world.m_46961_(pos, false);
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity entity;
        if (state.m_155947_() && (entity = context.m_43725_().m_7702_(context.m_8083_())) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.needsPower = !en.needsPower;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult m_6227_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity entity;
        if (state.m_155947_() && (entity = level.m_7702_(pos)) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.needsPower = !en.needsPower;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6861_(BlockState arg, Level arg2, BlockPos arg3, Block arg4, BlockPos arg5, boolean bl) {
        BlockEntity entity;
        if (arg.m_155947_() && !arg2.f_46443_ && (entity = arg2.m_7702_(arg3)) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.powered = arg2.m_276867_(arg3);
        }
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.m_61143_((Property)FACING)).m_122434_();
    }

    public VoxelShape m_5940_(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return switch (((Direction)arg.m_61143_((Property)FACING)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
        };
    }

    public Class<MotorBlockEntity> getBlockEntityClass() {
        return MotorBlockEntity.class;
    }

    public BlockEntityType<? extends MotorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.entry.get();
    }
}

