/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.flotage.plugin.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import committee.nova.flotage.FlotageUtil;
import committee.nova.flotage.init.FloBlocks;
import committee.nova.flotage.plugin.jei.FloJEI;
import committee.nova.flotage.recipe.RackMode;
import committee.nova.flotage.recipe.RackRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RackCategory
implements IRecipeCategory<RackRecipe> {
    protected static final ResourceLocation BACKGROUND_LOC = FlotageUtil.asRes("textures/gui/jei/rack.png");
    private final int regularProcessTime;
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public RackCategory(final IGuiHelper guiHelper) {
        this.regularProcessTime = 200;
        this.background = guiHelper.createDrawable(BACKGROUND_LOC, 0, 0, 160, 65);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FloBlocks.OAK_RACK.get()));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer processTime) {
                return guiHelper.drawableBuilder(BACKGROUND_LOC, 160, 0, 24, 17).buildAnimated(processTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getArrow(RackRecipe recipe) {
        int time = recipe.getProcessTime();
        if (time <= 0) {
            time = this.regularProcessTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)time);
    }

    protected void drawDryTime(RackRecipe recipe, PoseStack poseStack, int y) {
        int time = recipe.getProcessTime();
        if (time > 0) {
            int dryTimeSeconds = time / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{dryTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            fontRenderer.m_92889_(poseStack, (Component)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawMode(RackRecipe recipe, PoseStack poseStack, int y) {
        RackMode mode = recipe.getMode();
        if (mode != RackMode.EMPTY) {
            MutableComponent modeText = Component.m_237115_((String)("gui.flotage.rack.mode." + mode.getType()));
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)modeText);
            fontRenderer.m_92889_(poseStack, (Component)modeText, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RackRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 19).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 19).addItemStack(recipe.m_8043_());
    }

    public void draw(RackRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(stack, 67, 18);
        this.drawDryTime(recipe, stack, 47);
        this.drawMode(recipe, stack, 37);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.flotage.rack");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<RackRecipe> getRecipeType() {
        return FloJEI.RACK;
    }
}

