/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.flotage.recipe;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;

public enum RackMode {
    EMPTY("empty"),
    SUN("sun"),
    NIGHT("night"),
    RAIN("rain"),
    SNOW("snow"),
    SMOKE("smoke"),
    RAIN_AT("rain_at"),
    SNOW_AT("snow_at");

    private final String type;

    private RackMode(String type) {
        this.type = type;
    }

    public static RackMode switchingMode(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            if (level.m_46471_()) {
                Biome biome = (Biome)level.m_204166_(pos).m_203334_();
                if (biome.m_47530_() == Biome.Precipitation.SNOW && biome.m_198904_(pos)) {
                    if (level.m_45527_(pos) && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_()) {
                        return SNOW_AT;
                    }
                    return SNOW;
                }
                if (level.m_46758_(pos.m_7494_())) {
                    return RAIN_AT;
                }
                if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50683_) && ((Boolean)level.m_8055_(pos.m_7495_()).m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    return SMOKE;
                }
                return RAIN;
            }
            if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50683_) && ((Boolean)level.m_8055_(pos.m_7495_()).m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                return SMOKE;
            }
            if (level.m_46461_()) {
                return SUN;
            }
            return NIGHT;
        }
        return EMPTY;
    }

    public String getType() {
        return this.type;
    }

    public static RackMode match(String s) {
        for (RackMode mode : RackMode.values()) {
            if (!mode.getType().equals(s)) continue;
            return mode;
        }
        return EMPTY;
    }
}

