/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.flotage.recipe;

import committee.nova.flotage.FlotageConfig;
import committee.nova.flotage.init.FloRecipeSerializers;
import committee.nova.flotage.init.FloRecipeTypes;
import committee.nova.flotage.recipe.RackMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RackRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type = (RecipeType)FloRecipeTypes.RACK.get();
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int processTime;
    protected final RackMode mode;

    public RackRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, int processTime, String mode) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.processTime = processTime;
        this.mode = RackMode.match(mode);
    }

    public RackRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, int processTime, RackMode mode) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.processTime = processTime;
        this.mode = mode;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag tag = container.m_8020_(0).m_41783_();
        if (tag != null) {
            itemstack.m_41751_(tag.m_6426_());
        }
        return itemstack;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public boolean isRecipeConditionMet(Level world, BlockPos pos) {
        if (!((Boolean)FlotageConfig.RACK_RECIPE_CONDITIONS.get()).booleanValue()) {
            return true;
        }
        return this.getMode() == RackMode.switchingMode(world, pos) || this.getMode() == RackMode.EMPTY;
    }

    public RackMode getMode() {
        return this.mode;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.ingredient);
        return list;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FloRecipeSerializers.RACK_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public boolean m_5598_() {
        return true;
    }
}

