/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.flotage.tile;

import committee.nova.flotage.init.FloBlockEntities;
import committee.nova.flotage.init.FloRecipeTypes;
import committee.nova.flotage.init.FloTags;
import committee.nova.flotage.recipe.RackRecipe;
import committee.nova.flotage.util.StockUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class RackBlockEntity
extends BlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    protected final RecipeType<RackRecipe> recipeType = (RecipeType)FloRecipeTypes.RACK.get();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private static final int[] SLOTS = new int[]{0};
    private final ItemStackHandler STACKS = new ItemStackHandler();
    private Direction itemDirection = Direction.UP;
    private int totalTime;
    private int processTime;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});

    public RackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RackBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FloBlockEntities.RACK_TILE.get(), pos, state);
    }

    protected void read(CompoundTag tag) {
        this.STACKS.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)((CompoundTag)Objects.requireNonNull(tag.m_128423_("RecipeItem")))));
        this.totalTime = tag.m_128451_("TotalTime");
        this.processTime = tag.m_128451_("ProcessTime");
        this.itemDirection = Direction.valueOf((String)tag.m_128461_("ItemDirection").toUpperCase());
        CompoundTag recipesUsed = tag.m_128469_("RecipesUsed");
        for (String s : recipesUsed.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), recipesUsed.m_128451_(s));
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.read(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.read(tag);
    }

    public CompoundTag write(CompoundTag tag) {
        ItemStack stack = this.STACKS.getStackInSlot(0);
        tag.m_128365_("RecipeItem", (Tag)stack.serializeNBT());
        tag.m_128405_("TotalTime", this.totalTime);
        tag.m_128405_("ProcessTime", this.processTime);
        tag.m_128359_("ItemDirection", String.valueOf(this.itemDirection));
        CompoundTag tag1 = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> tag1.m_128405_(resourceLocation.toString(), integer.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)tag1);
        return tag;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        return this.write(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.write(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> this.m_5995_());
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public Direction getItemDirection() {
        return this.itemDirection;
    }

    public void setItemDirection(Direction itemDirection) {
        this.itemDirection = itemDirection;
    }

    public int[] m_7071_(Direction direction) {
        return SLOTS;
    }

    public boolean m_7155_(int id, ItemStack stack, @Nullable Direction direction) {
        if (stack.m_204117_(FloTags.UNSTACKABLE)) {
            return this.STACKS.getStackInSlot(0).m_41613_() < 1;
        }
        if (stack.m_41613_() + this.STACKS.getStackInSlot(0).m_41613_() > StockUtil.defLimitAmount) {
            return false;
        }
        return direction != Direction.DOWN && id == 0;
    }

    public boolean m_7157_(int id, ItemStack stack, Direction direction) {
        return this.processTime == 0 && this.totalTime != 0 && id == 0;
    }

    public int m_6643_() {
        return this.STACKS.getSlots();
    }

    public boolean m_7983_() {
        return this.STACKS.getStackInSlot(0).m_41619_();
    }

    protected List<ItemStack> shiftStack() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.set(0, this.m_8020_(0));
        return stacks;
    }

    public ItemStack m_8020_(int id) {
        return this.STACKS.getStackInSlot(id);
    }

    public ItemStack m_7407_(int id, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.shiftStack(), (int)id, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int id) {
        ItemStack itemstack = this.m_8020_(id);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.m_6836_(id, itemstack);
        return itemstack;
    }

    public void m_6836_(int id, ItemStack stack) {
        this.STACKS.setStackInSlot(id, stack);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.m_6836_(0, ItemStack.f_41583_);
        this.m_6596_();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_5809_(StackedContents contents) {
        contents.m_36491_(this.m_8020_(0));
    }

    private void process(Level world, RackRecipe iRecipe) {
        ItemStack itemstack = this.m_8020_(0);
        ItemStack itemstack1 = iRecipe.m_5874_((Container)this);
        if (itemstack1 != itemstack && !world.f_46443_) {
            int i = Math.min(itemstack.m_41613_(), StockUtil.defLimitAmount);
            itemstack1.m_41764_(i);
            this.m_6836_(0, itemstack1);
            this.recipesUsed.clear();
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RackBlockEntity tile) {
        ItemStack itemstack;
        assert (level != null);
        if (!level.f_46443_ && !(itemstack = tile.m_8020_(0)).m_41619_()) {
            Optional iRecipe = level.m_7465_().m_44015_(tile.recipeType, (Container)tile, level);
            tile.m_6596_();
            if (iRecipe.isPresent()) {
                RackRecipe recipe = (RackRecipe)iRecipe.get();
                tile.totalTime = recipe.getProcessTime();
                if (recipe.isRecipeConditionMet(level, pos)) {
                    ++tile.processTime;
                    tile.m_6029_(recipe);
                    if (tile.processTime >= tile.totalTime) {
                        tile.processTime = 0;
                        tile.process(tile.f_58857_, recipe);
                    }
                }
            } else {
                tile.processTime = 0;
                tile.recipesUsed.clear();
            }
        }
    }

    public void m_6596_() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        this.m_58900_().m_60701_((LevelAccessor)this.f_58857_, this.m_58899_(), 3);
        super.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

