/*
 * Decompiled with CFR 0.152.
 */
package com.zetal.hardmodeores;

import com.google.common.base.Preconditions;
import com.zetal.hardmodeores.HardModeOresMod;
import com.zetal.hardmodeores.block.BlockRichDiamondOre;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class HardModeOresRegistry {
    public static final Block RICH_GOLD_ORE = new BlockOre().func_149711_c(3.0f).func_149752_b(5.0f).func_149663_c("richgoldore");
    public static final Block RICH_IRON_ORE = new BlockOre().func_149711_c(3.0f).func_149752_b(5.0f).func_149663_c("richironore");
    public static final Block RICH_DIAMOND_ORE = new BlockRichDiamondOre().func_149711_c(3.0f).func_149752_b(5.0f).func_149663_c("richdiamondore");
    public static final Item DIAMOND_SHARD = new Item().func_77655_b("diamondshard").func_77637_a(CreativeTabs.field_78035_l);

    @Mod.EventBusSubscriber(modid="hardmodeores")
    public static class RegistrationHandler {
        public static final Block[] BLOCKS = new Block[]{RICH_GOLD_ORE, RICH_IRON_ORE, RICH_DIAMOND_ORE};
        public static final Item[] ITEMS = new Item[]{DIAMOND_SHARD};

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            RICH_GOLD_ORE.setHarvestLevel("pickaxe", 2);
            RICH_IRON_ORE.setHarvestLevel("pickaxe", 1);
            RICH_DIAMOND_ORE.setHarvestLevel("pickaxe", 2);
            IForgeRegistry registry = event.getRegistry();
            for (Block b : BLOCKS) {
                String regName = b.func_149739_a().substring(5);
                registry.register(b.setRegistryName(regName));
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                ItemBlock item = new ItemBlock(block);
                Block block2 = item.func_179223_d();
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block2.getRegistryName(), (String)"Block %s has null registry name", (Object)block2);
                registry.register(item.setRegistryName(registryName));
                HardModeOresMod.proxy.itemModelRegister((Item)item, registryName);
            }
            for (Block block : ITEMS) {
                String regName = block.func_77658_a().substring(5);
                registry.register(block.setRegistryName(regName));
                HardModeOresMod.proxy.itemModelRegister((Item)block, block.getRegistryName());
            }
        }
    }
}

