/*
 * Decompiled with CFR 0.152.
 */
package com.zetal.hardmodeores;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class HardModeOresConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Common {
        private static final int defaultIronMaxVeinSize = 6;
        private static final int defaultGoldMaxVeinSize = 6;
        private static final int defaultDiamondMaxVeinSize = 5;
        private static final int defaultIronVeinsPerChunk = 10;
        private static final int defaultGoldVeinsPerChunk = 5;
        private static final int defaultDiamondVeinsPerChunk = 1;
        private static final int defaultIronMinHeight = 0;
        private static final int defaultGoldMinHeight = 0;
        private static final int defaultDiamondMinHeight = 1;
        private static final int defaultIronMaxHeight = 64;
        private static final int defaultGoldMaxHeight = 32;
        private static final int defaultDiamondMaxHeight = 16;
        private static final int defaultIronChunkPercentChance = 100;
        private static final int defaultGoldChunkPercentChance = 100;
        private static final int defaultDiamondChunkPercentChance = 50;
        public final ForgeConfigSpec.ConfigValue<Integer> IronMaxVeinSize;
        public final ForgeConfigSpec.ConfigValue<Integer> GoldMaxVeinSize;
        public final ForgeConfigSpec.ConfigValue<Integer> DiamondMaxVeinSize;
        public final ForgeConfigSpec.ConfigValue<Integer> IronVeinsPerChunk;
        public final ForgeConfigSpec.ConfigValue<Integer> GoldVeinsPerChunk;
        public final ForgeConfigSpec.ConfigValue<Integer> DiamondVeinsPerChunk;
        public final ForgeConfigSpec.ConfigValue<Integer> IronMinHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> GoldMinHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> DiamondMinHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> IronMaxHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> GoldMaxHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> DiamondMaxHeight;
        private final ForgeConfigSpec.ConfigValue<Integer> IronChunkPercentChance;
        private final ForgeConfigSpec.ConfigValue<Integer> GoldChunkPercentChance;
        private final ForgeConfigSpec.ConfigValue<Integer> DiamondChunkPercentChance;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Ores");
            this.IronMaxVeinSize = builder.worldRestart().define("Rich Iron Max Vein Size", (Object)6);
            this.IronVeinsPerChunk = builder.worldRestart().define("Rich Iron Veins Per Chunk", (Object)10);
            this.IronMinHeight = builder.worldRestart().define("Rich Iron Min Height", (Object)0);
            this.IronMaxHeight = builder.worldRestart().define("Rich Iron Max Height", (Object)64);
            this.IronChunkPercentChance = builder.comment("Percentage chance from 0 to 100 for the Veins Per Chunk to trigger.").worldRestart().defineInRange("Rich Iron Chunk Percent Occurrence", 100, 0, 100);
            this.GoldMaxVeinSize = builder.worldRestart().define("Rich Gold Max Vein Size", (Object)6);
            this.GoldVeinsPerChunk = builder.worldRestart().define("Rich Gold Veins Per Chunk", (Object)5);
            this.GoldMinHeight = builder.worldRestart().define("Rich Gold Min Height", (Object)0);
            this.GoldMaxHeight = builder.worldRestart().define("Rich Gold Max Height", (Object)32);
            this.GoldChunkPercentChance = builder.comment("Percentage chance from 0 to 100 for the Veins Per Chunk to trigger.").worldRestart().defineInRange("Rich Gold Chunk Percent Occurrence", 100, 0, 100);
            this.DiamondMaxVeinSize = builder.worldRestart().define("Rich Diamond Max Vein Size", (Object)5);
            this.DiamondVeinsPerChunk = builder.worldRestart().define("Rich Diamond Veins Per Chunk", (Object)1);
            this.DiamondMinHeight = builder.worldRestart().define("Rich Diamond Min Height", (Object)1);
            this.DiamondMaxHeight = builder.worldRestart().define("Rich Diamond Max Height", (Object)16);
            this.DiamondChunkPercentChance = builder.comment("Percentage chance from 0 to 100 for the Veins Per Chunk to trigger.").worldRestart().defineInRange("Rich Diamond Chunk Percent Occurrence", 50, 0, 100);
            builder.pop();
        }

        public int getIronChunkPercentChance() {
            return this.getChunkPercentChance((Integer)this.IronChunkPercentChance.get());
        }

        public int getGoldChunkPercentChance() {
            return this.getChunkPercentChance((Integer)this.GoldChunkPercentChance.get());
        }

        public int getDiamondChunkPercentChance() {
            return this.getChunkPercentChance((Integer)this.DiamondChunkPercentChance.get());
        }

        private int getChunkPercentChance(int chance) {
            if (chance <= 0) {
                return Integer.MAX_VALUE;
            }
            return 100 / chance;
        }
    }
}

