/*
 * Decompiled with CFR 0.152.
 */
package com.zetal.hardmodeores;

import com.google.common.collect.ImmutableList;
import com.zetal.hardmodeores.HardModeOresConfig;
import com.zetal.hardmodeores.HardModeOresRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HardModeOresWorldGenerator {
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_IRON_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((OreBlock)HardModeOresRegistry.RICH_IRON_ORE.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((OreBlock)HardModeOresRegistry.RICH_DEEPSLATE_IRON_ORE.get()).m_49966_()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_GOLD_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((OreBlock)HardModeOresRegistry.RICH_GOLD_ORE.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((OreBlock)HardModeOresRegistry.RICH_DEEPSLATE_GOLD_ORE.get()).m_49966_()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_DIAMOND_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((OreBlock)HardModeOresRegistry.RICH_DIAMOND_ORE.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((OreBlock)HardModeOresRegistry.RICH_DEEPSLATE_DIAMOND_ORE.get()).m_49966_()));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_IRON_CFG = FeatureUtils.m_206488_((String)"ore_rich_iron", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_IRON_TARGET_LIST, ((Integer)HardModeOresConfig.COMMON.IronMaxVeinSize.get()).intValue()));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_IRON_SMALL_CFG = FeatureUtils.m_206488_((String)"ore_rich_iron_small", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_IRON_TARGET_LIST, (Integer)HardModeOresConfig.COMMON.IronMaxVeinSize.get() / 2));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_GOLD_CFG = FeatureUtils.m_206488_((String)"ore_rich_gold", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_GOLD_TARGET_LIST, ((Integer)HardModeOresConfig.COMMON.GoldMaxVeinSize.get()).intValue()));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_GOLD_BURIED_CFG = FeatureUtils.m_206488_((String)"ore_rich_gold_buried", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_GOLD_TARGET_LIST, ((Integer)HardModeOresConfig.COMMON.GoldMaxVeinSize.get()).intValue(), 0.5f));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_DIAMOND_SMALL_CFG = FeatureUtils.m_206488_((String)"ore_rich_diamond_small", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, (Integer)HardModeOresConfig.COMMON.DiamondMaxVeinSize.get() / 2, 0.25f));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_DIAMOND_LARGE_CFG = FeatureUtils.m_206488_((String)"ore_rich_diamond_large", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, (int)((float)((Integer)HardModeOresConfig.COMMON.DiamondMaxVeinSize.get()).intValue() * 1.5f), 0.35f));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_DIAMOND_BURIED_CFG = FeatureUtils.m_206488_((String)"ore_rich_diamond_buried", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, ((Integer)HardModeOresConfig.COMMON.DiamondMaxVeinSize.get()).intValue(), 1.0f));
    public static final Holder<PlacedFeature> ORE_IRON_UPPER = PlacementUtils.m_206509_((String)"ore_rich_iron_upper", ORE_IRON_CFG, HardModeOresWorldGenerator.commonOrePlacement(45, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)80), (VerticalAnchor)VerticalAnchor.m_158922_((int)384))));
    public static final Holder<PlacedFeature> ORE_IRON_MIDDLE = PlacementUtils.m_206509_((String)"ore_rich_iron_middle", ORE_IRON_CFG, HardModeOresWorldGenerator.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)56))));
    public static final Holder<PlacedFeature> ORE_IRON_SMALL = PlacementUtils.m_206509_((String)"ore_rich_iron_small", ORE_IRON_SMALL_CFG, HardModeOresWorldGenerator.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)72))));
    public static final Holder<PlacedFeature> ORE_GOLD = PlacementUtils.m_206509_((String)"ore_rich_gold", ORE_GOLD_BURIED_CFG, HardModeOresWorldGenerator.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)32))));
    public static final Holder<PlacedFeature> ORE_GOLD_LOWER = PlacementUtils.m_206509_((String)"ore_rich_gold_lower", ORE_GOLD_BURIED_CFG, HardModeOresWorldGenerator.orePlacement((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)1)), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)-48))));
    public static final Holder<PlacedFeature> ORE_DIAMOND = PlacementUtils.m_206509_((String)"ore_rich_diamond", ORE_DIAMOND_SMALL_CFG, HardModeOresWorldGenerator.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-80), (VerticalAnchor)VerticalAnchor.m_158930_((int)80))));
    public static final Holder<PlacedFeature> ORE_DIAMOND_LARGE = PlacementUtils.m_206509_((String)"ore_rich_diamond_large", ORE_DIAMOND_LARGE_CFG, HardModeOresWorldGenerator.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-80), (VerticalAnchor)VerticalAnchor.m_158930_((int)80))));
    public static final Holder<PlacedFeature> ORE_DIAMOND_BURIED = PlacementUtils.m_206509_((String)"ore_rich_diamond_buried", ORE_DIAMOND_BURIED_CFG, HardModeOresWorldGenerator.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-80), (VerticalAnchor)VerticalAnchor.m_158930_((int)80))));
    public static final List<Holder<PlacedFeature>> OVERWORLD_ORES = new ArrayList<Holder<PlacedFeature>>();

    @SubscribeEvent
    public static void biomeLoading(BiomeLoadingEvent event) {
        List features = event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES);
        if (event.getCategory() != Biome.BiomeCategory.NETHER && event.getCategory() != Biome.BiomeCategory.THEEND) {
            OVERWORLD_ORES.forEach(ore -> features.add(ore));
        }
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return HardModeOresWorldGenerator.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return HardModeOresWorldGenerator.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
    }

    public static <FC extends FeatureConfiguration> ConfiguredFeature<FC, ?> register(String p_195006_, ConfiguredFeature<FC, ?> p_195007_) {
        return (ConfiguredFeature)Registry.m_122961_((Registry)BuiltinRegistries.f_123861_, (String)p_195006_, p_195007_);
    }

    static {
        OVERWORLD_ORES.add(ORE_IRON_UPPER);
        OVERWORLD_ORES.add(ORE_IRON_MIDDLE);
        OVERWORLD_ORES.add(ORE_IRON_SMALL);
        OVERWORLD_ORES.add(ORE_GOLD);
        OVERWORLD_ORES.add(ORE_GOLD_LOWER);
        OVERWORLD_ORES.add(ORE_DIAMOND);
        OVERWORLD_ORES.add(ORE_DIAMOND_LARGE);
        OVERWORLD_ORES.add(ORE_DIAMOND_BURIED);
    }
}

