/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans;

import com.craftix.hostile_humans.Config;
import com.craftix.hostile_humans.entity.entities.Human;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HumanUtil {
    public static ItemStack[] EDIBLE_ITEMS = new ItemStack[]{Items.f_42410_.m_7968_(), Items.f_42406_.m_7968_(), Items.f_42486_.m_7968_(), Items.f_42530_.m_7968_(), Items.f_42531_.m_7968_(), Items.f_42572_.m_7968_(), Items.f_42575_.m_7968_(), Items.f_42580_.m_7968_(), Items.f_42582_.m_7968_(), Items.f_42619_.m_7968_(), Items.f_42620_.m_7968_(), Items.f_42674_.m_7968_(), Items.f_42677_.m_7968_(), Items.f_42687_.m_7968_(), Items.f_42697_.m_7968_(), Items.f_42698_.m_7968_(), Items.f_42699_.m_7968_(), Items.f_42658_.m_7968_(), Items.f_42659_.m_7968_(), Items.f_42730_.m_7968_(), Items.f_42732_.m_7968_(), Items.f_42576_.m_7968_(), Items.f_42780_.m_7968_(), Items.f_151079_.m_7968_()};
    public static String[] greetings = new String[]{"Huh? INTRUDER!", "Who are you? GET OUT OF HERE.", "You will die intruder!", "You stepped into the wrong place.", "Leave this area!", "Leave this place!", "I would give up.", "You made a mistake coming here.", "Run or die!", "What the hell, who are you?", "Give up and I'll let you run.", "You in the wrong place mate.", "You think you can just barge into this place and live?", "Your life has come to a end stranger.", "Why are you here?", "Run or i'll slit your throat.", "GET OUT OF HERE!", "Your in the wrong place and I needed to relieve some stress, i'm going to cut you up.", "I have pent up anger and you're trespassing, staand stillll!", "LEAVE", "You think your slick?", "HEY YOU, STOP!", "Whoever you are, LEAVE OR DIE.", "I don't know who you are but you just made a mistake.", "Please leave this area or else.", "I'm going to enjoy slicing you up.", "I don't know who you are but I'm going to cut you up AND FEED YOUR PARTS TO WOLVES!", "Wrong place mate, run now while you can.", "Why are you doing this?", "You just made the biggest mistake of your life mate.", "I hope your ready to lose your life stranger.", "Thou Shan't pass, heh.", "How did- ? Your not welcomed here.", "Go back to where you came from.", "You're a fool to be here. You won't survive.", "You don't belong here.", "There's no escape for you.", "I'm only warning you once, get out of here.", "You're playing with fire, intruder. You'll get burned.", "You're in over your head, you don't stand a chance against me!", "You're wasting your time here.", "You're a brave one, I'll give you that. But bravery won't save you.", "Your in for a world of pain mate. I'll make you suffer!", "You're out of my league, you can't handle me!", "Mate if your asking for trouble, trouble is what you'll get.", "You shouldn't be here.", "I'll squash you like a bug, DIE!", "I'll make you beg for mercy.", "There's nothing but death for you here.", "Please I don't want to fight, run away.", "I hope you're ready.", "Please just run.", "GET OUT OF HERE."};

    public static boolean isStructureDisabled(String value) {
        return Arrays.asList(((String)Config.disabledStructures.get()).replace(" ", "").split(",")).contains(value);
    }

    public static boolean isRangedWeapon(ItemStack value) {
        return value.m_150930_(Items.f_42717_) || value.m_150930_(Items.f_42411_);
    }

    public static boolean isMeleeWeapon(ItemStack value) {
        return !value.m_41619_() && (value.m_41720_() instanceof SwordItem || value.m_41720_() instanceof AxeItem);
    }

    public static boolean isTrident(ItemStack value) {
        return !value.m_41619_() && value.m_41720_() instanceof TridentItem;
    }

    public static boolean isShield(ItemStack value) {
        return !value.m_41619_() && value.m_41720_() instanceof ShieldItem;
    }

    public static boolean isConsumable(ItemStack stack) {
        return stack.m_41613_() > 0 && (stack.m_41780_() == UseAnim.EAT || stack.m_41780_() == UseAnim.DRINK);
    }

    public static boolean canStartEating(Human human) {
        if (human.toAvoid != null) {
            return false;
        }
        if (!HumanUtil.isLowHp((LivingEntity)human)) {
            return false;
        }
        if (human.m_6117_()) {
            return false;
        }
        if (human.m_5448_() != null) {
            return false;
        }
        if (human.m_6117_()) {
            return false;
        }
        if (human.eatingColldown != 0) {
            return false;
        }
        return (long)human.f_19797_ >= 120L + human.lastCombatTime;
    }

    public static boolean isEmptyFood(ItemStack stack) {
        return stack.m_41619_() || stack.m_150930_(Items.f_42590_) || stack.m_150930_(Items.f_42399_);
    }

    public static boolean isLookingAtTarget(LivingEntity mob, Entity target) {
        Vec3 vec3 = mob.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(target.m_20185_() - mob.m_20185_(), target.m_20188_() - mob.m_20188_(), target.m_20189_() - mob.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.4 / d0 && mob.m_142582_(target);
    }

    @NotNull
    public static ItemStack createSwordBanner() {
        ItemStack banner = Items.f_42660_.m_7968_();
        CompoundTag blockData = banner.m_41698_("BlockEntityTag");
        ListTag patterns = new ListTag();
        CompoundTag c1 = new CompoundTag();
        c1.m_128405_("Color", 4);
        c1.m_128359_("Pattern", "flo");
        patterns.add((Object)c1);
        c1 = new CompoundTag();
        c1.m_128405_("Color", 7);
        c1.m_128359_("Pattern", "hh");
        patterns.add((Object)c1);
        c1 = new CompoundTag();
        c1.m_128405_("Color", 0);
        c1.m_128359_("Pattern", "cs");
        patterns.add((Object)c1);
        c1 = new CompoundTag();
        c1.m_128405_("Color", 7);
        c1.m_128359_("Pattern", "br");
        patterns.add((Object)c1);
        c1 = new CompoundTag();
        c1.m_128405_("Color", 7);
        c1.m_128359_("Pattern", "bl");
        patterns.add((Object)c1);
        c1 = new CompoundTag();
        c1.m_128405_("Color", 7);
        c1.m_128359_("Pattern", "cbo");
        patterns.add((Object)c1);
        blockData.m_128365_("Patterns", (Tag)patterns);
        return banner;
    }

    public static boolean isLadder(BlockState state, LivingEntity entity, BlockPos pos) {
        return state.isLadder((LevelReader)entity.f_19853_, pos, entity);
    }

    public static int createLadderNodeFor(int nodeID, Node[] nodes, Node origin, Function<BlockPos, Node> nodeGetter, BlockGetter getter, Mob mob) {
        Node node;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin.f_77271_, origin.f_77272_ + 1, origin.f_77273_);
        if (HumanUtil.isLadder(getter.m_8055_((BlockPos)pos), (LivingEntity)mob, (BlockPos)pos) && (node = nodeGetter.apply((BlockPos)pos)) != null && !node.f_77279_) {
            node.f_77281_ = 0.0f;
            node.f_77282_ = BlockPathTypes.WALKABLE;
            if (nodeID + 1 < nodes.length) {
                nodes[nodeID++] = node;
            }
        }
        pos.m_122178_(pos.m_123341_(), pos.m_123342_() - 2, pos.m_123343_());
        if (HumanUtil.isLadder(getter.m_8055_((BlockPos)pos), (LivingEntity)mob, (BlockPos)pos) && (node = nodeGetter.apply((BlockPos)pos)) != null && !node.f_77279_) {
            node.f_77281_ = 0.0f;
            node.f_77282_ = BlockPathTypes.WALKABLE;
            if (nodeID + 1 < nodes.length) {
                nodes[nodeID++] = node;
            }
        }
        return nodeID;
    }

    public static boolean isLowHp(LivingEntity human) {
        if (human.m_21206_().m_41720_() == Items.f_42747_) {
            return false;
        }
        return (double)human.m_21223_() < (double)human.m_21233_() * (Double)Config.fleeHpPercent.get();
    }

    public static boolean shouldFightCreeper(LivingEntity human) {
        return String.valueOf(human.m_142049_()).hashCode() % 100 < 20;
    }
}

