/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.client.renderer;

import com.craftix.hostile_humans.entity.entities.Human;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HumanRenderer
extends HumanoidMobRenderer<Human, PlayerModel<Human>> {
    public HumanRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    public Vec3 getRenderOffset(Human p_117785_, float p_117786_) {
        return p_117785_.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)p_117785_, p_117786_);
    }

    protected void scale(Human p_117798_, PoseStack p_117799_, float p_117800_) {
        p_117799_.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    protected void renderNameTag(Human human, Component p_117809_, PoseStack p_117810_, MultiBufferSource p_117811_, int p_117812_) {
        if (human.m_8077_() && !human.m_7770_().getString().isEmpty()) {
            super.m_7649_((Entity)human, p_117809_, p_117810_, p_117811_, p_117812_);
        }
    }

    protected void setupRotations(Human p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.m_20998_(p_117806_);
        if (p_117802_.m_21255_()) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.m_21256_() + p_117806_;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.m_21209_()) {
                p_117803_.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - p_117802_.m_146909_())));
            }
            Vec3 vec3 = p_117802_.m_20252_(p_117806_);
            Vec3 vec31 = p_117802_.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                p_117803_.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = p_117802_.m_20069_() ? -90.0f - p_117802_.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            p_117803_.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            if (p_117802_.m_6067_()) {
                p_117803_.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(Human entity) {
        return entity.getResourceLocation();
    }

    public void render(Human human, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        ItemStack stack2;
        ((PlayerModel)this.f_115290_).f_102815_ = HumanoidModel.ArmPose.EMPTY;
        ((PlayerModel)this.f_115290_).f_102816_ = HumanoidModel.ArmPose.EMPTY;
        ItemStack stack = human.m_21205_();
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof CrossbowItem) {
                if (human.isChargingCrossbow()) {
                    this.setHandPose(human, HumanoidModel.ArmPose.CROSSBOW_CHARGE);
                } else {
                    this.setHandPose(human, HumanoidModel.ArmPose.CROSSBOW_HOLD);
                }
            } else if (stack.m_41720_() instanceof BowItem && human.m_5912_()) {
                this.setHandPose(human, HumanoidModel.ArmPose.BOW_AND_ARROW);
            } else if (stack.m_41720_() instanceof TridentItem && human.m_6117_() && human.m_21212_() > 10) {
                this.setHandPose(human, HumanoidModel.ArmPose.THROW_SPEAR);
            } else {
                this.setHandPose(human, HumanoidModel.ArmPose.ITEM);
            }
        }
        if (!(stack2 = human.m_21206_()).m_41619_()) {
            if (stack2.m_41720_().canPerformAction(human.m_21206_(), ToolActions.SHIELD_BLOCK)) {
                if (human.m_21254_()) {
                    this.setOffHandPose(human, HumanoidModel.ArmPose.BLOCK);
                }
            } else {
                this.setOffHandPose(human, HumanoidModel.ArmPose.ITEM);
            }
        }
        super.m_7392_((Mob)human, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    private void setHandPose(Human entity, HumanoidModel.ArmPose pose) {
        if (entity.m_5737_() == HumanoidArm.RIGHT) {
            ((PlayerModel)this.f_115290_).f_102816_ = pose;
        } else {
            ((PlayerModel)this.f_115290_).f_102815_ = pose;
        }
    }

    private void setOffHandPose(Human entity, HumanoidModel.ArmPose pose) {
        if (entity.m_5737_() != HumanoidArm.RIGHT) {
            ((PlayerModel)this.f_115290_).f_102816_ = pose;
        } else {
            ((PlayerModel)this.f_115290_).f_102815_ = pose;
        }
    }
}

