/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity;

import com.craftix.hostile_humans.entity.AggressionMode;
import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.data.HumanData;
import com.craftix.hostile_humans.entity.data.HumansDataSync;
import com.craftix.hostile_humans.entity.entities.HumanTier;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HumanMobEntityData
extends TamableAnimal
implements HumansDataSync {
    public static final EntityDataAccessor<BlockPos> DATA_SIT_POS = SynchedEntityData.m_135353_(HumanMobEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<BlockPos> DATA_HOME_POS = SynchedEntityData.m_135353_(HumanMobEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(HumanMobEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_NAME = SynchedEntityData.m_135353_(HumanMobEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(HumanMobEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATA_TIER = SynchedEntityData.m_135353_(HumanMobEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DATA_SYNC_TICK = 10;
    public String team = "";
    protected UUID persistentAngerTarget;
    private BlockPos orderedToPosition = null;
    private AggressionMode aggressionLevel = AggressionMode.PASSIVE;
    private boolean isDataSyncNeeded = false;
    private HumanEntity humanEntity;
    private int dataSyncTicker = 0;

    protected HumanMobEntityData(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
    }

    @Override
    public HumanEntity getSyncReference() {
        return this.humanEntity;
    }

    public void setSyncReference(HumanEntity humanEntity) {
        this.humanEntity = humanEntity;
    }

    public boolean isTamable() {
        return false;
    }

    public Player getNearestPlayer(TargetingConditions targetingConditions) {
        return this.f_19853_.m_45946_(targetingConditions, (LivingEntity)this);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)charging);
    }

    public void setDataSyncNeeded() {
        if (!this.f_19853_.f_46443_ && this.hasOwner()) {
            this.isDataSyncNeeded = true;
        }
    }

    @Override
    public boolean getDataSyncNeeded() {
        return this.isDataSyncNeeded;
    }

    @Override
    public void setDataSyncNeeded(boolean dirty) {
        if (!this.f_19853_.f_46443_) {
            this.isDataSyncNeeded = dirty;
        }
    }

    public String getVariant() {
        return (String)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    public void setVariant(String variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant);
    }

    public HumanTier getTier() {
        return HumanTier.byId((Integer)this.f_19804_.m_135370_(DATA_TIER));
    }

    public void setTier(HumanTier variant) {
        this.f_19804_.m_135381_(DATA_TIER, (Object)variant.id);
    }

    public String getCustomHumanMobName() {
        return (String)this.f_19804_.m_135370_(DATA_NAME);
    }

    public TextComponent getCustomHumanMobNameComponent() {
        return new TextComponent(this.getCustomHumanMobName());
    }

    public boolean hasOwner() {
        return this.m_142504_() != null;
    }

    public boolean hasOwnerAndIsAlive() {
        return this.m_142504_() != null && this.m_6084_();
    }

    public void setOrderedToPosition(BlockPos blockPos) {
        if (this.orderedToPosition == blockPos) {
            return;
        }
        this.orderedToPosition = blockPos;
        this.setDataSyncNeeded();
    }

    public AggressionMode getAggressionLevel() {
        return this.aggressionLevel;
    }

    public void setAggressionLevel(AggressionMode aggressionLevel) {
        if (this.aggressionLevel == aggressionLevel) {
            return;
        }
        this.aggressionLevel = aggressionLevel;
        this.setDataSyncNeeded();
    }

    public void toggleAggressionLevel() {
        AggressionMode nextAggressionLevel = this.aggressionLevel.getNext();
        int loopProtection = 0;
        int maxLoopSize = AggressionMode.values().length;
        while (!this.isSupportedAggressionLevel(nextAggressionLevel) && loopProtection++ < maxLoopSize) {
            nextAggressionLevel = nextAggressionLevel.getNext();
        }
        if (nextAggressionLevel != this.aggressionLevel && this.isSupportedAggressionLevel(this.aggressionLevel)) {
            this.setAggressionLevel(nextAggressionLevel);
        }
    }

    public boolean isSupportedAggressionLevel(AggressionMode aggressionLevel) {
        return aggressionLevel != null;
    }

    @Nullable
    public HumanData getData() {
        return this.getData(this.m_142081_());
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        super.m_8061_(equipmentSlot, itemStack);
        HumanData data = this.getData();
        if (data != null && equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            data.setArmorItem(equipmentSlot.m_20749_(), itemStack);
        }
        this.setDataSyncNeeded();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_NAME, (Object)"");
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)"skin1");
        this.f_19804_.m_135372_(DATA_TIER, (Object)1);
        this.f_19804_.m_135372_(DATA_SIT_POS, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(DATA_HOME_POS, (Object)new BlockPos(0, 0, 0));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_("Variant", this.getVariant());
        compoundTag.m_128405_("SitPosX", this.getSitPos().m_123341_());
        compoundTag.m_128405_("SitPosY", this.getSitPos().m_123342_());
        compoundTag.m_128405_("SitPosZ", this.getSitPos().m_123343_());
        if (this.getHomePos() != null) {
            compoundTag.m_128405_("HomePosX", this.getHomePos().m_123341_());
            compoundTag.m_128405_("HomePosY", this.getHomePos().m_123342_());
            compoundTag.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        }
        compoundTag.m_128359_("HumanTeam", this.team);
    }

    public BlockPos getSitPos() {
        return (BlockPos)this.m_20088_().m_135370_(DATA_SIT_POS);
    }

    @Nullable
    public BlockPos getHomePos() {
        BlockPos pos = (BlockPos)this.m_20088_().m_135370_(DATA_HOME_POS);
        if (pos.m_123342_() == 0 && pos.m_123341_() == 0 && pos.m_123343_() == 0) {
            return null;
        }
        return pos;
    }

    public void setHomePos(BlockPos pos) {
        this.m_20088_().m_135381_(DATA_HOME_POS, (Object)pos);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        int i = compoundTag.m_128451_("SitPosX");
        int j = compoundTag.m_128451_("SitPosY");
        int k = compoundTag.m_128451_("SitPosZ");
        this.team = compoundTag.m_128461_("HumanTeam");
        if (this.team.isEmpty()) {
            this.team = "human";
        }
        this.f_19804_.m_135381_(DATA_SIT_POS, (Object)new BlockPos(i, j, k));
        int i1 = compoundTag.m_128451_("HomePosX");
        int j1 = compoundTag.m_128451_("HomePosY");
        int k1 = compoundTag.m_128451_("HomePosZ");
        this.f_19804_.m_135381_(DATA_HOME_POS, (Object)new BlockPos(i1, j1, k1));
        this.setVariant(compoundTag.m_128461_("Variant"));
    }

    public HumanEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.dataSyncTicker++ >= 10 && this.syncDataIfNeeded()) {
            this.dataSyncTicker = 0;
        }
    }
}

