/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class FenceInteractGoal
extends Goal {
    protected Mob mob;
    protected BlockPos fencePosPos = BlockPos.f_121853_;
    protected boolean hasFence;
    private boolean passed;
    private float doorOpenDirX;
    private float fenceOpenDirZ;

    public FenceInteractGoal(Mob p_25193_) {
        this.mob = p_25193_;
        if (!GoalUtils.m_26894_((Mob)p_25193_)) {
            throw new IllegalArgumentException("Unsupported mob type for FenceInteractGoal");
        }
    }

    public static boolean isFence(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof FenceGateBlock;
    }

    protected boolean isOpen() {
        if (!this.hasFence) {
            return false;
        }
        BlockState blockstate = this.mob.f_19853_.m_8055_(this.fencePosPos);
        if (!(blockstate.m_60734_() instanceof FenceGateBlock)) {
            this.hasFence = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)FenceGateBlock.f_53341_);
    }

    protected void setOpen(boolean p_25196_) {
        BlockState blockstate;
        if (this.hasFence && (blockstate = this.mob.f_19853_.m_8055_(this.fencePosPos)).m_60734_() instanceof FenceGateBlock) {
            this.setOpen((FenceGateBlock)blockstate.m_60734_(), (Entity)this.mob, this.mob.f_19853_, blockstate, this.fencePosPos, p_25196_);
        }
    }

    public void setOpen(FenceGateBlock fenceGateBlock, @Nullable Entity p_153166_, Level p_153167_, BlockState p_153168_, BlockPos p_153169_, boolean p_153170_) {
        if (p_153168_.m_60713_((Block)fenceGateBlock) && (Boolean)p_153168_.m_61143_((Property)FenceGateBlock.f_53341_) != p_153170_) {
            p_153167_.m_7731_(p_153169_, (BlockState)p_153168_.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(p_153170_)), 10);
            this.playSound(fenceGateBlock, p_153167_, p_153169_, p_153170_);
            p_153167_.m_142346_(p_153166_, p_153170_ ? GameEvent.f_157796_ : GameEvent.f_157793_, p_153169_);
        }
    }

    private void playSound(FenceGateBlock fenceGateBlock, Level p_52760_, BlockPos p_52761_, boolean p_52762_) {
        p_52760_.m_5898_((Player)null, p_52762_ ? this.getOpenSound() : this.getCloseSound(), p_52761_, 0);
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public boolean m_8036_() {
        if (!GoalUtils.m_26894_((Mob)this.mob)) {
            return false;
        }
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.mob.m_21573_();
        Path path = groundpathnavigation.m_26570_();
        if (path != null && !path.m_77392_() && groundpathnavigation.m_26492_()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node node = path.m_77375_(i);
                this.fencePosPos = new BlockPos(node.f_77271_, node.f_77272_ + 1, node.f_77273_);
                if (this.mob.m_20275_((double)this.fencePosPos.m_123341_(), this.mob.m_20186_(), (double)this.fencePosPos.m_123343_()) > 2.25) continue;
                this.hasFence = FenceInteractGoal.isFence(this.mob.f_19853_, this.fencePosPos);
                if (!this.hasFence) continue;
                return true;
            }
            this.fencePosPos = this.mob.m_142538_();
            this.hasFence = FenceInteractGoal.isFence(this.mob.f_19853_, this.fencePosPos);
            return this.hasFence;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.passed;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.fencePosPos.m_123341_() + 0.5 - this.mob.m_20185_());
        this.fenceOpenDirZ = (float)((double)this.fencePosPos.m_123343_() + 0.5 - this.mob.m_20189_());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        float f1;
        float f = (float)((double)this.fencePosPos.m_123341_() + 0.5 - this.mob.m_20185_());
        float f2 = this.doorOpenDirX * f + this.fenceOpenDirZ * (f1 = (float)((double)this.fencePosPos.m_123343_() + 0.5 - this.mob.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }
}

