/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.ai.goal;

import com.craftix.hostile_humans.entity.PotionRangedAttackMob;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.SplashPotionItem;

public class PotionRangedAttackGoal
extends Goal {
    private final Mob mob;
    private final PotionRangedAttackMob rangedAttackMob;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private int seeTime;

    public PotionRangedAttackGoal(PotionRangedAttackMob p_25768_, double p_25769_, int p_25770_, float p_25771_) {
        this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
    }

    public PotionRangedAttackGoal(PotionRangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
        if (!(p_25773_ instanceof LivingEntity)) {
            throw new IllegalArgumentException("AttackGoal requires Mob implements PotionRangedAttackMob");
        }
        this.rangedAttackMob = p_25773_;
        this.mob = (Mob)p_25773_;
        this.speedModifier = p_25774_;
        this.attackIntervalMin = p_25775_;
        this.attackIntervalMax = p_25776_;
        this.attackRadius = p_25777_;
        this.attackRadiusSqr = p_25777_ * p_25777_;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity mobTarget = this.mob.m_5448_();
        if (mobTarget != null && mobTarget.m_6084_() && (this.mob.m_21205_().m_41720_() instanceof SplashPotionItem || this.mob.m_21206_().m_41720_() instanceof SplashPotionItem)) {
            this.target = mobTarget;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.mob.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double distanceToSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = hasLineOfSight ? ++this.seeTime : 0;
        if (distanceToSqr > (double)this.attackRadiusSqr || this.seeTime >= 5) {
            // empty if block
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!hasLineOfSight) {
                return;
            }
            float v = (float)Math.sqrt(distanceToSqr) / this.attackRadius;
            float clamp = Mth.m_14036_((float)v, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.performPotionRangedAttack(this.target, clamp);
            this.attackTime = Mth.m_14143_((float)(v * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(distanceToSqr) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

