/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.ai.goal;

import com.craftix.hostile_humans.Config;
import com.craftix.hostile_humans.HumanUtil;
import com.craftix.hostile_humans.entity.entities.Human;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RunFromTarget
extends Goal {
    protected final Human human;
    protected final float maxDist;
    protected final PathNavigation pathNav;
    protected final Predicate<LivingEntity> avoidPredicate;
    protected final Predicate<LivingEntity> predicateOnAvoidEntity;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    protected Path path;
    Vec3 targetPos = null;
    boolean jump;

    public RunFromTarget(Human p_25027_, float p_25029_, double p_25030_, double p_25031_) {
        this(p_25027_, p_25052_ -> true, p_25029_, p_25030_, p_25031_, EntitySelector.f_20406_::test);
    }

    public RunFromTarget(Human p_25040_, Predicate<LivingEntity> p_25042_, float p_25043_, double p_25044_, double p_25045_, Predicate<LivingEntity> p_25046_) {
        this.human = p_25040_;
        this.avoidPredicate = p_25042_;
        this.maxDist = p_25043_;
        this.walkSpeedModifier = p_25044_;
        this.sprintSpeedModifier = p_25045_;
        this.predicateOnAvoidEntity = p_25046_;
        this.pathNav = p_25040_.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.human.m_21206_().m_150930_(Items.f_42747_)) {
            return false;
        }
        if ((double)(String.valueOf(this.human.m_142049_()).hashCode() % 100) > (Double)Config.fleeChance.get() * 100.0) {
            return false;
        }
        if (!HumanUtil.isLowHp((LivingEntity)this.human)) {
            return false;
        }
        if (this.human.m_5448_() != null || this.human.toAvoid == null || !(this.human.toAvoid.m_20270_((Entity)this.human) < 15.0f)) {
            this.human.toAvoid = this.human.m_5448_();
        }
        this.human.m_6710_(null);
        if (this.human.toAvoid == null) {
            return false;
        }
        return this.generatePathAwayFromAttacker();
    }

    private boolean generatePathAwayFromAttacker() {
        Vec3 vec3 = null;
        for (int i = 0; i < 10 && (vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.human, (int)64, (int)7, (Vec3)this.human.toAvoid.m_20182_())) == null; ++i) {
        }
        if (vec3 == null) {
            return false;
        }
        if (this.human.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.human.toAvoid.m_20280_((Entity)this.human)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        if (this.path != null) {
            this.targetPos = vec3;
        }
        return this.path != null;
    }

    public boolean m_8045_() {
        Player player;
        if (!HumanUtil.isLowHp((LivingEntity)this.human)) {
            return false;
        }
        LivingEntity livingEntity = this.human.toAvoid;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_5833_() || player.m_7500_())) {
            return false;
        }
        if (this.human.toAvoid == null) {
            return false;
        }
        if (this.human.m_20280_((Entity)this.human.toAvoid) > 256.0) {
            return false;
        }
        if (!this.human.m_20096_()) {
            this.jump = true;
        } else if (this.jump) {
            this.jump = false;
            this.pathNav.m_26573_();
            this.generatePathAwayFromAttacker();
            this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        }
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.human.isFleeing = false;
        this.human.onPlayerJumpCoolDown = 20;
        this.human.toAvoid = null;
    }

    public void m_8037_() {
        if (this.human.toAvoid == null) {
            return;
        }
        this.human.isFleeing = true;
        this.human.m_6710_(null);
        if (this.human.m_20280_((Entity)this.human.toAvoid) < 49.0) {
            this.human.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.human.m_21573_().m_26517_(this.walkSpeedModifier);
        }
    }
}

