/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.data;

import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.data.HumanServerData;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HumanManagerEventHandler {
    private static final Set<Entity> entitySet = ConcurrentHashMap.newKeySet();
    private static final short SYNC_TICK = 25;
    private static short ticks = 0;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        HumanManagerEventHandler.updateOrRegisterHumanMob(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityTeleportEvent(EntityTeleportEvent event) {
        HumanManagerEventHandler.updateOrRegisterHumanMob(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        HumanManagerEventHandler.updateOrRegisterHumanMob(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        HumanManagerEventHandler.updateHumanMobData(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingDamageEvent(LivingDamageEvent event) {
        HumanManagerEventHandler.scheduleHumanMobDataUpdate(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        HumanManagerEventHandler.scheduleHumanMobDataUpdate(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingHealEvent(LivingHealEvent event) {
        HumanManagerEventHandler.scheduleHumanMobDataUpdate(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        HumanManagerEventHandler.updateHumanMobData(event.getEntity());
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 25) {
                HumanManagerEventHandler.syncHumanMobData();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent
    public static void handlePlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        HumanManagerEventHandler.verifyHHFollowerForPlayer(event.getPlayer());
        HumanManagerEventHandler.syncHHFollowersDataToPlayer(event.getPlayer());
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        HumanManagerEventHandler.syncHHFollowersDataToPlayer(event.getPlayer());
    }

    private static void scheduleHumanMobDataUpdate(Entity entity) {
        HumanEntity humanEntity;
        if (entity instanceof HumanEntity && (humanEntity = (HumanEntity)entity).hasOwner()) {
            entitySet.add(entity);
        }
    }

    private static void syncHumanMobData() {
        if (entitySet.isEmpty()) {
            return;
        }
        Iterator<Entity> entityIterator = entitySet.iterator();
        while (entityIterator.hasNext()) {
            Entity entity = entityIterator.next();
            if (entity != null) {
                HumanManagerEventHandler.updateOrRegisterHumanMob(entity);
            }
            entityIterator.remove();
        }
    }

    private static void syncHHFollowersDataToPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HumanServerData.get().syncHumanData(serverPlayer.m_142081_());
        }
    }

    private static void updateOrRegisterHumanMob(Entity entity) {
        if (entity instanceof HumanEntity) {
            HumanEntity humanEntity = (HumanEntity)entity;
            if (!humanEntity.m_183503_().f_46443_ && humanEntity.hasOwner()) {
                HumanServerData.get().updateOrRegisterHumanMob(humanEntity);
            }
        }
    }

    private static void updateHumanMobData(Entity entity) {
        if (entity instanceof HumanEntity) {
            HumanEntity humanEntity = (HumanEntity)entity;
            if (!humanEntity.m_183503_().f_46443_ && humanEntity.hasOwner()) {
                HumanServerData.get().updateHumanData(humanEntity);
            }
        }
    }

    private static void verifyHHFollowerForPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HumanServerData data = HumanServerData.get();
            if (data == null) {
                return;
            }
            MinecraftServer server = serverPlayer.m_20194_();
            Iterator serverLevels = server.m_129785_().iterator();
            Set<Entity> humanMobEntitiesEntityInOwnersDimension = data.getHumanMobsEntity(player.m_142081_(), serverPlayer.m_183503_());
            while (serverLevels.hasNext()) {
                ServerLevel serverLevel = (ServerLevel)serverLevels.next();
                if (serverPlayer.m_183503_() == serverLevel) continue;
                for (Entity humanEntity : humanMobEntitiesEntityInOwnersDimension) {
                    Entity entity = serverLevel.m_8791_(humanEntity.m_142081_());
                    if (entity == null) continue;
                    entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
                }
            }
        }
    }
}

