/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.data;

import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.data.HumanData;
import com.craftix.hostile_humans.entity.data.HumansServerDataClientSync;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class HumanServerData
extends SavedData {
    public static final String HUMAN_MOBS_TAG = "HumanMobs";
    private static ConcurrentHashMap<UUID, HumanData> humanMobEntitiesMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<UUID, Set<HumanData>> humanMobsPerPlayerMap = new ConcurrentHashMap();
    private static MinecraftServer server;
    private static HumanServerData data;

    public HumanServerData() {
        this.m_77762_();
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        humanMobEntitiesMap = new ConcurrentHashMap();
        humanMobsPerPlayerMap = new ConcurrentHashMap();
    }

    public static void prepare(MinecraftServer server) {
        if (server == null || server == HumanServerData.server && data != null) {
            return;
        }
        HumanServerData.server = server;
        data = (HumanServerData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(HumanServerData::load, HumanServerData::new, HumanServerData.getFileId());
    }

    public static void setData(HumanServerData data) {
        HumanServerData.data = data;
        HumanServerData.data.m_77762_();
    }

    public static HumanServerData get() {
        if (data == null) {
            HumanServerData.prepare(ServerLifecycleHooks.getCurrentServer());
        }
        return data;
    }

    public static String getFileId() {
        return "hostile_humans";
    }

    private static void addHuman(HumanData humanMobEntity) {
        humanMobEntitiesMap.put(humanMobEntity.getUUID(), humanMobEntity);
        UUID ownerUUID = humanMobEntity.getOwnerUUID();
        if (ownerUUID != null) {
            Set humanMobEntities = humanMobsPerPlayerMap.computeIfAbsent(ownerUUID, key -> ConcurrentHashMap.newKeySet());
            humanMobEntities.remove(humanMobEntity);
            humanMobEntities.add(humanMobEntity);
        }
    }

    private static void addHuman(CompoundTag compoundTag) {
        HumanServerData.addHuman(new HumanData(compoundTag));
    }

    public static HumanServerData load(CompoundTag compoundTag) {
        HumanServerData humanMobEntitiesData = new HumanServerData();
        if (compoundTag.m_128441_(HUMAN_MOBS_TAG)) {
            ListTag humanMobListTag = compoundTag.m_128437_(HUMAN_MOBS_TAG, 10);
            for (int i = 0; i < humanMobListTag.size(); ++i) {
                HumanServerData.addHuman(humanMobListTag.m_128728_(i));
            }
        }
        return humanMobEntitiesData;
    }

    public HumanData getHumanMob(UUID humanMobUUID) {
        return humanMobEntitiesMap.get(humanMobUUID);
    }

    public Entity getHumanMobEntity(UUID humanMobUUID, ServerLevel serverLevel) {
        HumanData humanMobEntityData = this.getHumanMob(humanMobUUID);
        if (humanMobEntityData != null && serverLevel != null) {
            return serverLevel.m_8791_(humanMobEntityData.getUUID());
        }
        return null;
    }

    public Set<HumanData> getHumanMobs(UUID ownerUUID) {
        return humanMobsPerPlayerMap.get(ownerUUID);
    }

    public Set<Entity> getHumanMobsEntity(UUID ownerUUID, ServerLevel serverLevel) {
        HashSet<Entity> result = new HashSet<Entity>();
        Set<HumanData> humanMobEntitiesData = this.getHumanMobs(ownerUUID);
        if (humanMobEntitiesData != null) {
            for (HumanData humanMobEntityData : humanMobEntitiesData) {
                Entity entity = this.getHumanMobEntity(humanMobEntityData.getUUID(), serverLevel);
                if (entity == null) continue;
                result.add(entity);
            }
        }
        return result;
    }

    public void updateOrRegisterHumanMob(HumanEntity humanMobEntity) {
        if (humanMobEntitiesMap.get(humanMobEntity.m_142081_()) == null) {
            this.registerHumanMob(humanMobEntity);
        } else {
            this.updateHumanMob(humanMobEntity);
        }
    }

    public HumanData updateHumanMob(HumanEntity entity) {
        HumanData humanData = humanMobEntitiesMap.get(entity.m_142081_());
        if (humanData == null) {
            this.registerHumanMob(entity);
            return null;
        }
        humanData.load(entity);
        UUID ownerUUID = humanData.getOwnerUUID();
        if (ownerUUID != null) {
            Set humanDataSet = humanMobsPerPlayerMap.computeIfAbsent(ownerUUID, key -> ConcurrentHashMap.newKeySet());
            humanDataSet.remove(humanData);
            humanDataSet.add(humanData);
        }
        this.m_77762_();
        this.syncHumanData(humanData);
        return humanData;
    }

    public void updateHumanData(HumanEntity humanMobEntity) {
        if (humanMobEntity.m_142049_() > 1) {
            this.updateHumanMob(humanMobEntity);
        }
    }

    public HumanData registerHumanMob(HumanEntity humanMobEntity) {
        return this.registerHumanMob(humanMobEntity, false);
    }

    public HumanData registerHumanMob(HumanEntity humanMobEntity, boolean requiredOwner) {
        if (humanMobEntitiesMap.get(humanMobEntity.m_142081_()) != null) {
            return humanMobEntitiesMap.get(humanMobEntity.m_142081_());
        }
        if (requiredOwner && !humanMobEntity.hasOwner()) {
            return null;
        }
        HumanData humanMobEntity2 = new HumanData(humanMobEntity);
        HumanServerData.addHuman(humanMobEntity2);
        this.m_77762_();
        if (humanMobEntity2.hasOwner()) {
            this.syncHumanData(humanMobEntity2);
        }
        return humanMobEntity2;
    }

    public void syncHumanData(UUID ownerUUID) {
        if (ownerUUID == null) {
            return;
        }
        Set<HumanData> humanMobEntitiesData = this.getHumanMobs(ownerUUID);
        HumansServerDataClientSync.syncHumanData(ownerUUID, humanMobEntitiesData);
    }

    public void syncHumanData(HumanData humanMobEntityData) {
        HumansServerDataClientSync.syncHumanData(humanMobEntityData);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag humanMobListTag = new ListTag();
        for (HumanData humanMobEntity : humanMobEntitiesMap.values()) {
            if (humanMobEntity == null) continue;
            CompoundTag humanMobEntityCompoundTag = new CompoundTag();
            humanMobEntity.save(humanMobEntityCompoundTag);
            humanMobListTag.add((Object)humanMobEntityCompoundTag);
        }
        compoundTag.m_128365_(HUMAN_MOBS_TAG, (Tag)humanMobListTag);
        return compoundTag;
    }
}

