/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.entities;

import com.craftix.hostile_humans.Config;
import com.craftix.hostile_humans.HostileHumans;
import com.craftix.hostile_humans.HumanUtil;
import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.PotionRangedAttackMob;
import com.craftix.hostile_humans.entity.ai.goal.AvoidCreeperGoal;
import com.craftix.hostile_humans.entity.ai.goal.AvoidTNTGoal;
import com.craftix.hostile_humans.entity.ai.goal.BowAttack;
import com.craftix.hostile_humans.entity.ai.goal.CrossbowGoal;
import com.craftix.hostile_humans.entity.ai.goal.FindWaterOnFireGoal;
import com.craftix.hostile_humans.entity.ai.goal.HumanLookAtPlayerGoal;
import com.craftix.hostile_humans.entity.ai.goal.LadderClimbGoal;
import com.craftix.hostile_humans.entity.ai.goal.MeleeAttackGoal;
import com.craftix.hostile_humans.entity.ai.goal.NearestAttackableTargetGoalCustom;
import com.craftix.hostile_humans.entity.ai.goal.NearestAttackableTargetGoalWithHumanLimiter;
import com.craftix.hostile_humans.entity.ai.goal.OpenFenceGoal;
import com.craftix.hostile_humans.entity.ai.goal.PotionRangedAttackGoal;
import com.craftix.hostile_humans.entity.ai.goal.RaiseShieldGoal;
import com.craftix.hostile_humans.entity.ai.goal.RandomStrollGoalFar;
import com.craftix.hostile_humans.entity.ai.goal.RandomStrollGoalWithHome;
import com.craftix.hostile_humans.entity.ai.goal.RunFromTarget;
import com.craftix.hostile_humans.entity.ai.goal.TridentAttackGoal;
import com.craftix.hostile_humans.entity.entities.HumanInventoryGenerator;
import com.craftix.hostile_humans.entity.entities.HumanTier;
import com.craftix.hostile_humans.entity.entities.ModEntityType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class Human
extends HumanEntity
implements RangedAttackMob,
CrossbowAttackMob,
PotionRangedAttackMob {
    private static final ItemStack[] EXTRA_EDIBLE_ITEMS = new ItemStack[]{Items.f_42436_.m_7968_(), PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43587_), PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43590_)};
    private static final UUID MODIFIER_UUID = UUID.fromString("7a0811af-4025-4691-ba75-2d638d4ab3f4");
    private static final AttributeModifier USE_ITEM_SPEED_PENALTY = new AttributeModifier(MODIFIER_UUID, "Use item speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final Map<String, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        for (int i = 1; i <= 37; ++i) {
            String name = "skin" + i;
            hashMap.put(name, new ResourceLocation("hostile_humans", "textures/entity/human/" + name + ".png"));
        }
    });
    private final CrossbowGoal<Human> crossbowAttackGoal = new CrossbowGoal<Human>(this, 1.0, 15.0f);
    private final TridentAttackGoal tridentGoal = new TridentAttackGoal(this, 1.0, 40, 15.0f);
    private final BowAttack<Human> bowAttackGoal = new BowAttack<Human>(this, 1.0, 80, 15.0f);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal(this, 1.05, true);
    public int shieldCoolDown;
    public int switchingWeaponCoolDown;
    public int onPlayerJumpCoolDown;
    public int eatingColldown;
    public boolean isFleeing;
    public long lastCombatTime;
    @Nullable
    public LivingEntity toAvoid;
    public boolean isAlert;

    public Human(EntityType<? extends HumanEntity> entityType, Level level, HumanTier type) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21553_(true);
        this.m_6593_(null);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        ((GroundPathNavigation)this.m_21573_()).m_148214_(true);
        this.m_21573_().m_26529_(50.0f);
        this.setTier(type);
        this.initTeam(type);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_((Attribute)ForgeMod.REACH_DISTANCE.get(), 3.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new GroundPathNavigation((Mob)this, p_33802_);
    }

    private void initTeam(HumanTier type) {
        if (this.team.isEmpty()) {
            this.team = type == HumanTier.ROAMER ? "roamer" + this.m_21187_().nextInt(1, 100000) : "human";
        }
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        this.lastCombatTime = this.f_19797_;
        EquipmentSlot[] equipmentSlotArray = damageSource.m_7639_();
        if (equipmentSlotArray instanceof Player) {
            Player attacker = (Player)equipmentSlotArray;
            if (this.m_5448_() == null) {
                this.m_6710_((LivingEntity)attacker);
            }
        }
        if (amount > 1.0f) {
            EquipmentSlot[] slots;
            for (EquipmentSlot equipmentslot : slots = EquipmentSlot.values()) {
                ItemStack item;
                if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                double d = this.f_19796_.nextFloat();
                double d2 = this.getTier() == HumanTier.LEVEL1 ? 0.0025 : 0.00125;
                if (!(d < d2) || (item = this.m_6844_(equipmentslot)).m_41619_()) continue;
                this.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
                this.m_8061_(equipmentslot, Items.f_41852_.m_7968_());
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_VARIANT.get(this.getVariant());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(-10, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(-10, (Goal)new AvoidCreeperGoal((PathfinderMob)this, 10.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(-5, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(-5, (Goal)new OpenFenceGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FindWaterOnFireGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(0, (Goal)new RunFromTarget(this, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidTNTGoal((PathfinderMob)this, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new RaiseShieldGoal(this));
        this.f_21345_.m_25352_(-5, (Goal)new LadderClimbGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PotionRangedAttackGoal(this, 1.0, 10, 10.0f));
        if (this.m_6095_() == ModEntityType.ROAMER.get()) {
            this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoalFar((PathfinderMob)this, 0.65, 15, false));
        } else {
            this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoalWithHome(this, 0.65, 120, true));
        }
        this.f_21345_.m_25352_(11, (Goal)new HumanLookAtPlayerGoal((Mob)this, Player.class, 64.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, new NearestAttackableTargetGoalCustom<LivingEntity>((Mob)this, LivingEntity.class, 13, true, false, this::isAngryAt));
        this.f_21346_.m_25352_(0, new NearestAttackableTargetGoalWithHumanLimiter<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, target -> {
            if (this.getTier() == HumanTier.ROAMER) {
                return target instanceof Animal && String.valueOf(target.m_142049_()).hashCode() % 100 < 30;
            }
            return target instanceof Enemy && (!(target instanceof Creeper) || HumanUtil.shouldFightCreeper((LivingEntity)this));
        }));
    }

    public void setCombatTask() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_(this.bowAttackGoal);
            this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
            this.f_21345_.m_25363_(this.crossbowAttackGoal);
            this.f_21345_.m_25363_((Goal)this.tridentGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, this::canFireProjectileWeapon));
            if (this.m_21205_().m_41720_() instanceof TridentItem) {
                this.f_21345_.m_25352_(2, (Goal)this.tridentGoal);
                this.f_21345_.m_25352_(3, (Goal)this.meleeAttackGoal);
            } else if (itemstack.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(2, this.crossbowAttackGoal);
            } else if (itemstack.m_41720_() instanceof BowItem) {
                this.bowAttackGoal.setMinAttackInterval(40);
                this.f_21345_.m_25352_(2, this.bowAttackGoal);
            } else {
                this.f_21345_.m_25352_(2, (Goal)this.meleeAttackGoal);
            }
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean result = super.m_7327_(entityIn);
        this.m_6674_(InteractionHand.MAIN_HAND);
        return result;
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn)) {
            this.disableShield(true);
        }
    }

    public void disableShield(boolean increase) {
        float chance = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.f_19796_.nextFloat() < chance) {
            this.shieldCoolDown = 100;
            this.m_5810_();
            this.f_19853_.m_7605_((Entity)this, (byte)30);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        ArrayList<String> variants = new ArrayList<String>(TEXTURE_BY_VARIANT.keySet());
        this.setVariant((String)variants.get(this.f_19796_.nextInt(variants.size())));
        this.m_21553_(true);
        return spawnGroupData;
    }

    @Override
    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        if (!this.f_19853_.f_46443_ && !stack.m_41619_()) {
            this.setCombatTask();
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        if (this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return super.m_7975_(damageSourceIn);
    }

    protected void m_7909_(float damage) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && damage >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)damage);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, entity -> entity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
            }
        }
    }

    public void m_6672_(@NotNull InteractionHand hand) {
        super.m_6672_(hand);
        ItemStack itemstack = this.m_21120_(hand);
        if (itemstack.canPerformAction(ToolActions.SHIELD_BLOCK) || this.m_6898_(itemstack)) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            modifiableattributeinstance.m_22130_(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.m_22118_(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void m_5810_() {
        super.m_5810_();
        if (this.m_21051_(Attributes.f_22279_).m_22109_(USE_ITEM_SPEED_PENALTY)) {
            this.m_21051_(Attributes.f_22279_).m_22130_(USE_ITEM_SPEED_PENALTY);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCombatTask();
    }

    public boolean m_6779_(LivingEntity entity) {
        Human otherHuman;
        if (entity instanceof Human && (otherHuman = (Human)entity).m_6084_()) {
            return !this.team.equals(otherHuman.team);
        }
        return super.m_6779_(entity);
    }

    public boolean isAngryAt(LivingEntity entity) {
        Human otherHuman;
        if (entity instanceof Human && (otherHuman = (Human)entity).m_6084_()) {
            return !this.team.equals(otherHuman.team);
        }
        if (!this.m_6779_(entity)) {
            return false;
        }
        if (entity instanceof AbstractSchoolingFish) {
            return false;
        }
        if (entity instanceof Player) {
            return false;
        }
        return entity.m_142081_().equals(this.getPersistentAngerTarget());
    }

    @Override
    public void finalizeSpawn() {
        super.finalizeSpawn();
        HumanInventoryGenerator.generateInventory(this, false);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public void setBanner(ItemStack banner) {
        this.m_8061_(EquipmentSlot.HEAD, banner);
    }

    public void putItemAway(ItemStack stack) {
        for (int i = 0; i < 16; ++i) {
            if (!this.getData().getInventoryItem(i).m_41619_()) continue;
            this.getData().setInventoryItem(i, stack.m_41777_());
            break;
        }
        stack.m_41774_(stack.m_41613_());
        this.setCombatTask();
    }

    public boolean equipWeapon(Predicate<ItemStack> predicate) {
        return this.equipWeapon(predicate, EquipmentSlot.MAINHAND);
    }

    public boolean equipWeapon(Predicate<ItemStack> predicate, EquipmentSlot slot) {
        for (int i = 0; i < 16; ++i) {
            ItemStack inventoryItem = this.getData().getInventoryItem(i);
            if (!predicate.test(inventoryItem)) continue;
            if (!this.m_21205_().m_41619_()) {
                this.putItemAway(this.m_21205_().m_41777_());
            }
            this.m_8061_(slot, inventoryItem.m_41777_());
            inventoryItem.m_41774_(inventoryItem.m_41613_());
            this.setCombatTask();
            return true;
        }
        return false;
    }

    protected void m_8095_() {
        if (this.m_6898_(this.f_20935_)) {
            this.m_5634_(20.0f);
        }
        super.m_8095_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.f_19797_ % 20 == 0) {
            if (this.m_8077_() && this.m_7770_().getString().contains("give_random_gear")) {
                this.m_21557_(true);
                return;
            }
            this.m_21557_(false);
        }
        if (this.getData() == null) {
            HostileHumans.LOGGER.warn("Missing data during tick " + this);
            this.m_146870_();
            return;
        }
        if (this.toAvoid != null || this.m_5448_() != null) {
            this.lastCombatTime = this.f_19797_;
        }
        if (this.f_19797_ % 10 == 0) {
            this.tryEquipShield();
            this.tryEquipWeapon();
            this.tryEatingTick();
            this.tryEquipPotion();
        }
        if (this.f_19797_ % 300 == 0) {
            this.setCombatTask();
        }
    }

    private void tryEquipShield() {
        if (this.m_21206_().m_41619_()) {
            this.equipWeapon(HumanUtil::isShield, EquipmentSlot.OFFHAND);
        }
    }

    private void tryEquipPotion() {
        if (this.getTier() != HumanTier.LEVEL2) {
            return;
        }
        if (this.m_5448_() != null && (this.f_19797_ + String.valueOf(this.m_142049_()).hashCode()) % (Integer)Config.throwPotionsEvery.get() == 0) {
            Potion potion = Potions.f_43582_;
            if (!this.m_5448_().m_21023_(MobEffects.f_19597_)) {
                potion = Potions.f_43615_;
            } else if (this.m_5448_().m_21223_() >= 8.0f && !this.m_5448_().m_21023_(MobEffects.f_19614_)) {
                potion = Potions.f_43584_;
            } else if (!this.m_5448_().m_21023_(MobEffects.f_19613_) && this.f_19796_.nextFloat() < 0.25f) {
                potion = Potions.f_43593_;
            }
            if (potion == Potions.f_43584_ && this.m_5448_().m_6336_() == MobType.f_21641_) {
                potion = Potions.f_43587_;
            }
            if (potion == Potions.f_43582_ && this.m_5448_().m_6336_() == MobType.f_21641_) {
                potion = Potions.f_43623_;
            }
            ItemStack potionItem = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion);
            EquipmentSlot handSlot = this.f_19796_.nextFloat() < 0.3f ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            ItemStack slotItem = this.m_6844_(handSlot);
            if (!slotItem.m_41619_()) {
                this.putItemAway(slotItem);
            }
            potionItem.m_41663_(Enchantments.f_44963_, 1);
            this.m_8061_(handSlot, potionItem);
        }
    }

    private void tryEatingTick() {
        if (HumanUtil.canStartEating(this)) {
            EquipmentSlot handSlot = this.f_19796_.nextFloat() < 0.3f ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            ItemStack slotItem = this.m_6844_(handSlot);
            if (!slotItem.m_41619_()) {
                this.putItemAway(slotItem);
            }
            if (this.getTier() == HumanTier.LEVEL2 && (double)this.f_19796_.nextFloat() < 0.5) {
                this.m_8061_(handSlot, EXTRA_EDIBLE_ITEMS[(int)(Math.random() * (double)EXTRA_EDIBLE_ITEMS.length)]);
            } else {
                this.m_8061_(handSlot, HumanUtil.EDIBLE_ITEMS[(int)(Math.random() * (double)HumanUtil.EDIBLE_ITEMS.length)]);
            }
            this.eatingColldown = 100;
            this.m_6672_(handSlot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        }
    }

    private void tryEquipWeapon() {
        if (this.m_5448_() == null && this.f_19797_ % 200 == 0) {
            this.equipWeapon(HumanUtil::isRangedWeapon);
        }
        if (this.f_19797_ % 200 == 0) {
            this.equipWeapon(HumanUtil::isTrident);
        }
        if (this.m_21205_().m_41619_()) {
            if (!this.equipWeapon(HumanUtil::isTrident)) {
                this.equipWeapon(HumanUtil::isMeleeWeapon);
            }
        } else if (this.switchingWeaponCoolDown == 0 && this.m_5448_() != null && this.f_19797_ > 10 && !this.m_6117_()) {
            boolean forcedMelee;
            boolean isTargetFar = this.m_5448_().m_20270_((Entity)this) >= 3.0f;
            ItemStack handItem = this.m_6844_(EquipmentSlot.MAINHAND);
            boolean bl = forcedMelee = this.m_21223_() <= this.m_21233_() * 0.3f && String.valueOf(this.m_142049_()).hashCode() % 100 < 20;
            if (!(!forcedMelee && isTargetFar || HumanUtil.isMeleeWeapon(handItem))) {
                this.equipWeapon(HumanUtil::isMeleeWeapon);
            } else if (isTargetFar && !HumanUtil.isRangedWeapon(handItem)) {
                this.equipWeapon(HumanUtil::isRangedWeapon);
            }
            this.switchingWeaponCoolDown = 60;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 220 == 0 && this.m_5448_() == null && !this.f_19853_.f_46443_) {
            if (this.getData() != null) {
                for (ItemStack stack : this.getData().getInventoryItems()) {
                    this.m_21540_(stack);
                }
            } else {
                HostileHumans.LOGGER.warn("Missing data? " + this);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.switchingWeaponCoolDown > 0) {
            --this.switchingWeaponCoolDown;
        }
        if (this.onPlayerJumpCoolDown > 0) {
            --this.onPlayerJumpCoolDown;
        }
        if (this.eatingColldown > 0) {
            --this.eatingColldown;
        }
        this.m_21203_();
    }

    public boolean m_21540_(ItemStack stack) {
        if (this.m_5448_() != null) {
            return false;
        }
        EquipmentSlot equipmentslot = Human.m_147233_((ItemStack)stack);
        ItemStack itemstack = this.m_6844_(equipmentslot);
        boolean flag = this.m_7808_(stack, itemstack);
        if (flag && this.m_7252_(stack) && !(stack.m_41720_() instanceof TieredItem)) {
            double d0 = this.m_21519_(equipmentslot);
            if (!itemstack.m_41619_() && (double)Math.max(this.f_19796_.nextFloat() - 0.1f, 0.0f) < d0) {
                this.getData().storeInventoryItem(itemstack);
            }
            this.m_21468_(equipmentslot, stack);
            this.m_147218_(stack);
            return true;
        }
        return false;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    public Item getTameItem() {
        return Items.f_42415_;
    }

    @Override
    public Ingredient getFoodItems() {
        return Ingredient.m_43927_((ItemStack[])HumanUtil.EDIBLE_ITEMS);
    }

    @Override
    public int m_8100_() {
        return 600;
    }

    public float m_6100_() {
        return 1.0f;
    }

    public void m_6136_(boolean pIsCharging) {
        this.setCharging(pIsCharging);
    }

    public boolean canFireProjectileWeapon(Item item) {
        ProjectileWeaponItem weaponItem;
        return item instanceof ProjectileWeaponItem && this.m_5886_(weaponItem = (ProjectileWeaponItem)item);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile projectile, float angle) {
        this.m_32322_((LivingEntity)this, target, projectile, angle, 1.6f);
    }

    public ItemStack m_6298_(ItemStack p_21272_) {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_21205_().m_41720_() instanceof TridentItem) {
            this.performRangedAttackTrident(target, distanceFactor);
            return;
        }
        this.shieldCoolDown = 8;
        ItemStack weaponStack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, this::canFireProjectileWeapon));
        if (weaponStack.m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 1.6f);
        } else {
            ItemStack itemstack = this.m_6298_(weaponStack);
            AbstractArrow mobArrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            if (this.m_21205_().m_41720_() instanceof BowItem) {
                mobArrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(mobArrow);
            }
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - mobArrow.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            mobArrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)mobArrow);
        }
    }

    public void performRangedAttackTrident(LivingEntity p_32356_, float p_32357_) {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        ItemStack tridentStack = new ItemStack((ItemLike)Items.f_42713_);
        tridentStack.m_41663_(Enchantments.f_44963_, 1);
        tridentStack.m_41663_(Enchantments.f_44955_, 1);
        ThrownTrident throwntrident = new ThrownTrident(this.f_19853_, (LivingEntity)this, tridentStack);
        double d0 = p_32356_.m_20185_() - this.m_20185_();
        double d1 = p_32356_.m_20227_(0.3333333432674408) - throwntrident.m_20186_();
        double d2 = p_32356_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        throwntrident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        throwntrident.m_5602_((Entity)this);
        this.m_5496_(SoundEvents.f_12520_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)throwntrident);
    }

    @Override
    public void performPotionRangedAttack(LivingEntity target, float var2) {
        Vec3 deltaMovement = target.m_20184_();
        double $$3 = target.m_20185_() + deltaMovement.f_82479_ - this.m_20185_();
        double $$4 = target.m_20188_() - 1.1 - this.m_20186_();
        double $$5 = target.m_20189_() + deltaMovement.f_82481_ - this.m_20189_();
        double $$6 = Math.sqrt($$3 * $$3 + $$5 * $$5);
        ItemStack potionStack = null;
        if (this.m_21205_().m_41720_() instanceof SplashPotionItem) {
            potionStack = this.m_21205_();
        } else if (this.m_21206_().m_41720_() instanceof SplashPotionItem) {
            potionStack = this.m_21206_();
        }
        if (potionStack == null) {
            return;
        }
        ThrownPotion thrownPotion = new ThrownPotion(this.f_19853_, (LivingEntity)this);
        thrownPotion.m_37446_(potionStack.m_41777_());
        thrownPotion.m_146926_(thrownPotion.m_146909_() + 20.0f);
        thrownPotion.m_6686_($$3, $$4 + $$6 * 0.2, $$5, 0.75f, 8.0f);
        potionStack.m_41774_(1);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
        }
        this.f_19853_.m_7967_((Entity)thrownPotion);
    }
}

