/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.entities;

import com.craftix.hostile_humans.HostileHumans;
import com.craftix.hostile_humans.HumanUtil;
import com.craftix.hostile_humans.compat.ImmersiveArmors;
import com.craftix.hostile_humans.entity.entities.Human;
import com.craftix.hostile_humans.entity.entities.HumanTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ArrayUtils;

public class HumanInventoryGenerator {
    public static int[] tier1Armor = new int[]{0, 2, 3, 1};
    public static int[] tier2Armor = new int[]{3, 4};
    public static Item[] tier1Weapons = new Item[]{Items.f_42383_, Items.f_42425_, Items.f_42383_, Items.f_42425_, Items.f_42717_, Items.f_42411_};
    public static Item[] tier2Weapons = new Item[]{Items.f_42388_, Items.f_42391_, Items.f_42388_, Items.f_42388_, Items.f_42391_, Items.f_42717_, Items.f_42411_};
    public static Item[] rangedWeapons = new Item[]{Items.f_42717_, Items.f_42411_};
    public static Item[] extraWeapons = new Item[]{Items.f_42383_, Items.f_42425_};

    public static void generateInventory(Human human, boolean forceRanged) {
        int i22;
        if (human.getData() == null) {
            HostileHumans.LOGGER.warn("Missing data during inventory generation " + human);
            human.m_146870_();
            return;
        }
        int[] armorPick = tier1Armor;
        Item[] weaponPick = tier1Weapons;
        float enchantChance = 0.3f;
        float armorChance = 0.25f;
        Random random = human.m_21187_();
        HumanTier humanTier = human.getTier();
        switch (humanTier) {
            case LEVEL2: {
                armorPick = tier2Armor;
                weaponPick = tier2Weapons;
                enchantChance = 1.0f;
                armorChance = 0.15f;
                break;
            }
            case ROAMER: {
                enchantChance = 1.0f;
                armorChance = 0.2f;
                if (random.nextFloat() < 0.3f) {
                    armorPick = tier2Armor;
                }
                if (!(random.nextFloat() < 0.3f)) break;
                weaponPick = tier2Weapons;
            }
        }
        if (forceRanged) {
            weaponPick = rangedWeapons;
        }
        ItemStack stack = weaponPick[random.nextInt(weaponPick.length)].m_7968_();
        HumanInventoryGenerator.damage(human, stack);
        human.m_8061_(EquipmentSlot.MAINHAND, stack);
        float f = random.nextFloat();
        float f2 = humanTier == HumanTier.LEVEL2 ? 0.8f : (humanTier == HumanTier.LEVEL1 ? 0.1f : 0.4f);
        if (f < f2 && !HumanUtil.isRangedWeapon(human.m_6844_(EquipmentSlot.MAINHAND))) {
            if ((double)random.nextFloat() < 0.15 && humanTier == HumanTier.LEVEL2) {
                human.m_8061_(EquipmentSlot.OFFHAND, Items.f_42747_.m_7968_());
            } else {
                ItemStack shield = Items.f_42740_.m_7968_();
                HumanInventoryGenerator.damage(human, shield);
                human.m_8061_(EquipmentSlot.OFFHAND, shield);
            }
        }
        if (HumanUtil.isRangedWeapon(human.m_6844_(EquipmentSlot.MAINHAND))) {
            ItemStack extraWeapon = extraWeapons[random.nextInt(extraWeapons.length)].m_7968_();
            HumanInventoryGenerator.damage(human, extraWeapon);
            extraWeapon.m_41663_(Enchantments.f_44963_, 1);
            human.getData().setInventoryItem(0, extraWeapon);
        }
        int staticImmersivePick = -1;
        if ((double)random.nextFloat() < 0.45 && ModList.get().isLoaded("immersive_armors")) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i22 : armorPick) {
                list.add(i22);
            }
            list.addAll(Arrays.asList(5, 6));
            if (humanTier == HumanTier.LEVEL2) {
                list.add(7);
            }
            if (((staticImmersivePick = ((Integer)list.get(random.nextInt(list.size()))).intValue()) == 3 || staticImmersivePick == 5) && random.nextFloat() < 0.25f) {
                staticImmersivePick = (Integer)list.get(random.nextInt(list.size()));
            }
            if (staticImmersivePick == 5 && random.nextFloat() < 0.05f) {
                staticImmersivePick = (Integer)list.get(random.nextInt(list.size()));
            }
        }
        int pick = staticImmersivePick != -1 ? staticImmersivePick : armorPick[random.nextInt(armorPick.length)];
        int pickForChest = -1;
        Object[] slots = EquipmentSlot.values();
        ArrayUtils.reverse((Object[])slots);
        Object[] objectArray = slots;
        i22 = objectArray.length;
        for (int j = 0; j < i22; ++j) {
            Object object = objectArray[j];
            if (object.m_20743_() != EquipmentSlot.Type.ARMOR || humanTier != HumanTier.LEVEL2 && random.nextFloat() < armorChance && staticImmersivePick != -1) continue;
            if (object == EquipmentSlot.LEGS && pickForChest > pick) {
                pick = pickForChest;
            }
            Item item = HumanInventoryGenerator.customGetEquipmentForSlot((EquipmentSlot)object, pick);
            if (staticImmersivePick != -1) {
                item = ImmersiveArmors.getItemForSlot((EquipmentSlot)object, pick);
            }
            if (object == EquipmentSlot.CHEST) {
                pickForChest = pick;
            }
            if (item == null) continue;
            human.m_8061_((EquipmentSlot)object, HumanInventoryGenerator.damage(human, item.m_7968_()));
        }
        if (staticImmersivePick == -1) {
            int randomValue = random.nextInt(3) + 1;
            switch (randomValue) {
                case 2: {
                    human.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    break;
                }
                case 3: {
                    int pickOther = armorPick[random.nextInt(armorPick.length)];
                    Item item = HumanInventoryGenerator.customGetEquipmentForSlot(EquipmentSlot.LEGS, pickOther);
                    if (item == null) break;
                    human.m_8061_(EquipmentSlot.LEGS, HumanInventoryGenerator.damage(human, item.m_7968_()));
                }
            }
        }
        human.m_7908_(enchantChance);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            human.m_21380_(enchantChance, equipmentSlot);
        }
        if (humanTier == HumanTier.LEVEL2 && (double)random.nextFloat() < 0.05) {
            ItemStack tridentStack = Items.f_42713_.m_7968_();
            tridentStack.m_41663_(Enchantments.f_44955_, 1);
            tridentStack.m_41663_(Enchantments.f_44963_, 1);
            human.m_8061_(EquipmentSlot.MAINHAND, tridentStack);
        }
    }

    public static ItemStack damage(Human human, ItemStack inStack) {
        int damage = (int)((float)human.m_21187_().nextInt(inStack.m_41776_() - 1) * 1.35f);
        if (damage > inStack.m_41776_()) {
            damage = inStack.m_41776_() - 1;
        }
        inStack.m_41721_(damage);
        return inStack;
    }

    public static Item customGetEquipmentForSlot(EquipmentSlot slot, int level) {
        switch (slot) {
            case HEAD: {
                if (level == 0) {
                    return Items.f_42407_;
                }
                if (level == 1) {
                    return Items.f_42476_;
                }
                if (level == 2) {
                    return Items.f_42464_;
                }
                if (level == 3) {
                    return Items.f_42468_;
                }
                if (level == 4) {
                    return Items.f_42472_;
                }
            }
            case CHEST: {
                if (level == 0) {
                    return Items.f_42408_;
                }
                if (level == 1) {
                    return Items.f_42477_;
                }
                if (level == 2) {
                    return Items.f_42465_;
                }
                if (level == 3) {
                    return Items.f_42469_;
                }
                if (level == 4) {
                    return Items.f_42473_;
                }
            }
            case LEGS: {
                if (level == 0) {
                    return Items.f_42462_;
                }
                if (level == 1) {
                    return Items.f_42478_;
                }
                if (level == 2) {
                    return Items.f_42466_;
                }
                if (level == 3) {
                    return Items.f_42470_;
                }
                if (level == 4) {
                    return Items.f_42474_;
                }
            }
            case FEET: {
                if (level == 0) {
                    return Items.f_42463_;
                }
                if (level == 1) {
                    return Items.f_42479_;
                }
                if (level == 2) {
                    return Items.f_42467_;
                }
                if (level == 3) {
                    return Items.f_42471_;
                }
                if (level != 4) break;
                return Items.f_42475_;
            }
        }
        return null;
    }
}

