/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.entities;

import com.craftix.hostile_humans.HumanUtil;
import com.craftix.hostile_humans.compat.DungeonMobs;
import com.craftix.hostile_humans.entity.entities.Human;
import com.craftix.hostile_humans.entity.entities.ModEntityType;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.fml.ModList;

public class SpawnerEntity
extends Mob {
    protected SpawnerEntity(EntityType<? extends Mob> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.spawn((ServerLevel)this.f_19853_);
            this.m_146870_();
        }
    }

    private boolean spawn(ServerLevel level) {
        BlockPos blockpos = this.m_142538_();
        if (this.hasEnoughSpace((BlockGetter)level, blockpos)) {
            if (level.m_204166_(blockpos).m_203565_(Biomes.f_48173_)) {
                return false;
            }
            boolean currentTeam = false;
            boolean isPillagers = this.f_19796_.nextFloat() < 0.6f;
            int totalAmount = this.f_19796_.nextInt(3, 10);
            boolean bannerLeft = false;
            boolean bannerRight = false;
            ArrayList<Object> spawnedEntities = new ArrayList<Object>();
            for (int j = 0; j < totalAmount; ++j) {
                BlockPos pos = this.findSpawnPositionNear((LevelReader)level, blockpos, 4);
                if (pos == null) continue;
                if (isPillagers && currentTeam) {
                    if (this.f_19796_.nextBoolean()) {
                        spawnedEntities.add((LivingEntity)this.getRandomPillager().m_20600_(level, null, null, null, pos, MobSpawnType.EVENT, false, false));
                    }
                    spawnedEntities.add((LivingEntity)this.getRandomPillager().m_20600_(level, null, null, null, pos, MobSpawnType.EVENT, false, false));
                } else {
                    Human newHuman = (Human)((EntityType)ModEntityType.HUMAN1.get()).m_20600_(level, null, null, null, pos, MobSpawnType.EVENT, false, false);
                    spawnedEntities.add(newHuman);
                    if (newHuman != null) {
                        if (totalAmount > 5) {
                            if (currentTeam && !bannerLeft) {
                                bannerLeft = true;
                                newHuman.setBanner(HumanUtil.createSwordBanner());
                            }
                            if (!currentTeam && !bannerRight) {
                                bannerRight = true;
                                newHuman.setBanner(HumanUtil.createSwordBanner());
                            }
                        }
                        newHuman.team = currentTeam ? "team1" : "team2";
                    }
                }
                currentTeam = !currentTeam;
            }
            Iterator iterator = spawnedEntities.iterator();
            while (iterator.hasNext()) {
                LivingEntity entity;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20 * ((entity = (LivingEntity)iterator.next()) instanceof Human ? 15 : 10), 255, false, false, false));
            }
            return true;
        }
        return false;
    }

    EntityType getRandomPillager() {
        if (this.f_19796_.nextFloat() < 0.05f) {
            return EntityType.f_20518_;
        }
        if (this.f_19796_.nextFloat() < 0.05f && ModList.get().isLoaded("dungeon_mobs")) {
            return DungeonMobs.getRedstoneGolem();
        }
        EntityType[] list = new EntityType[]{EntityType.f_20513_, EntityType.f_20513_, EntityType.f_20568_, EntityType.f_20568_, EntityType.f_20513_, EntityType.f_20459_, EntityType.f_20493_, EntityType.f_20493_, EntityType.f_20493_};
        return list[(int)((float)list.length * this.f_19796_.nextFloat())];
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader levelReader, BlockPos blockPos, int radius) {
        BlockPos outPos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = blockPos.m_123341_() + this.f_19796_.nextInt(radius * 2) - radius;
            BlockPos blockpos1 = new BlockPos(j, l = levelReader.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = blockPos.m_123343_() + this.f_19796_.nextInt(radius * 2) - radius), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)levelReader, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            outPos = blockpos1;
            break;
        }
        return outPos;
    }

    private boolean hasEnoughSpace(BlockGetter p_35926_, BlockPos p_35927_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_35927_, (BlockPos)p_35927_.m_142082_(1, 2, 1))) {
            if (p_35926_.m_8055_(blockpos).m_60812_(p_35926_, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

