/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.DoorInteractGoal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DoorInteractGoal.class})
public abstract class DoorInteractMixin {
    @Shadow
    protected Mob f_25189_;

    private static boolean isMetalDoor(Level p_52746_, BlockPos p_52747_) {
        return DoorInteractMixin.isMetalDoor(p_52746_.m_8055_(p_52747_));
    }

    private static boolean isMetalDoor(BlockState p_52818_) {
        return p_52818_.m_60734_() instanceof DoorBlock && p_52818_.m_60767_() != Material.f_76320_ && p_52818_.m_60767_() != Material.f_76321_;
    }

    private static boolean canMobSeeBlock(Level world, Vec3 from, BlockPos to) {
        return world.m_45547_(new ClipContext(from, new Vec3((double)to.m_123341_() + 0.5, (double)to.m_123342_() + 0.5, (double)to.m_123343_() + 0.5), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    @Redirect(method={"canUse"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/DoorBlock;isWoodenDoor(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"))
    private boolean injected(Level level, BlockPos blockpos) {
        boolean isWoodenDoor = DoorBlock.m_52745_((Level)level, (BlockPos)blockpos);
        boolean isMetalDoor = DoorInteractMixin.isMetalDoor(level, blockpos);
        boolean isMetalOpen = false;
        if (isMetalDoor) {
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)(blockpos.m_123341_() - 2), (int)(blockpos.m_123342_() - 2), (int)(blockpos.m_123343_() - 2), (int)(blockpos.m_123341_() + 2), (int)(blockpos.m_123342_() + 2), (int)(blockpos.m_123343_() + 2))) {
                BlockState state = level.m_8055_(blockpos1);
                Block block = state.m_60734_();
                if (!DoorInteractMixin.canMobSeeBlock(level, this.f_25189_.m_146892_(), blockpos1)) continue;
                if (block instanceof ButtonBlock) {
                    ((ButtonBlock)block).m_51116_(state, level, blockpos1);
                    isMetalOpen = true;
                }
                if (!(block instanceof LeverBlock)) continue;
                ((LeverBlock)block).m_54676_(state, level, blockpos1);
                isMetalOpen = true;
            }
        }
        return isWoodenDoor || isMetalOpen;
    }
}

