/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.ai.behaviour;

import com.kaboomroads.lostfeatures.mixin.SensorAccessor;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;

public class AttackablesSensor
extends NearestVisibleLivingEntitySensor {
    public final TagKey<EntityType<?>> alwaysHostiles;
    public final Predicate<LivingEntity> predicate;

    public AttackablesSensor(TagKey<EntityType<?>> alwaysHostiles, Predicate<LivingEntity> predicate, int interval) {
        ((SensorAccessor)((Object)this)).setScanRate(interval);
        ((SensorAccessor)((Object)this)).setTimeToTick(SensorAccessor.getRandom().m_188503_(interval));
        this.alwaysHostiles = alwaysHostiles;
        this.predicate = predicate;
    }

    protected boolean m_142628_(@NotNull LivingEntity entity, @NotNull LivingEntity otherEntity) {
        return this.isClose(entity, otherEntity) && this.isHostileTarget(otherEntity) && Sensor.m_148312_((LivingEntity)entity, (LivingEntity)otherEntity);
    }

    private boolean isHostileTarget(LivingEntity entity) {
        return entity.m_6095_().m_204039_(this.alwaysHostiles);
    }

    private boolean isClose(LivingEntity entity, LivingEntity otherEntity) {
        double followRange = entity.m_21133_(Attributes.f_22277_);
        return otherEntity.m_20280_((Entity)entity) <= followRange * followRange;
    }

    protected void m_5578_(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        if (this.predicate.test(entity)) {
            super.m_5578_(level, entity);
        }
    }

    @NotNull
    protected MemoryModuleType<LivingEntity> m_142149_() {
        return MemoryModuleType.f_148194_;
    }
}

