/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.client.tuffgolem;

import com.kaboomroads.lostfeatures.entity.client.tuffgolem.TuffGolemAnimation;
import com.kaboomroads.lostfeatures.entity.custom.TuffGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class TuffGolemModel<T extends TuffGolem>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("lostfeatures", "tuff_golem"), "main");
    private final ModelPart golem;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public TuffGolemModel(ModelPart root) {
        this.golem = root.m_171324_("golem");
        this.leftArm = this.golem.m_171324_("body").m_171324_("arms").m_171324_("arm1");
        this.rightArm = this.golem.m_171324_("body").m_171324_("arms").m_171324_("arm2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition golem = partdefinition.m_171599_("golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = golem.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)0.0f));
        legs.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(28, 6).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-3.0f, (float)0.0f));
        legs.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-3.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        arms.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, -1.5f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        arms.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(12, 18).m_171488_(-3.0f, -1.5f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(28, 12).m_171488_(-1.0f, -0.5f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-3.0f));
        PartDefinition cloth = body.m_171599_("cloth", CubeListBuilder.m_171558_().m_171514_(46, 10).m_171488_(-4.0f, -1.0f, 6.0f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-3.0f));
        PartDefinition moving = cloth.m_171599_("moving", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(-4.0f, 0.0f, -1.0f, 8.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        moving.m_171599_("part", CubeListBuilder.m_171558_().m_171514_(46, 7).m_171488_(-3.999f, 0.001f, -0.01f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = (float)entity.m_20184_().m_165925_();
        float f1 = Mth.m_14036_((float)(f * 10000.0f), (float)0.5f, (float)1.5f);
        this.m_233385_(((TuffGolem)((Object)entity)).walkAnimationState, TuffGolemAnimation.WALK, ageInTicks, f1);
        this.m_233385_(((TuffGolem)((Object)entity)).displayAnimationState, TuffGolemAnimation.DISPLAY, ageInTicks, 1.0f);
        this.m_233385_(((TuffGolem)((Object)entity)).stopDisplayAnimationState, TuffGolemAnimation.STOP_DISPLAY, ageInTicks, 1.0f);
        this.m_233385_(((TuffGolem)((Object)entity)).shakeAnimationState, TuffGolemAnimation.SHAKE, ageInTicks, 1.0f);
        if (!((TuffGolem)((Object)entity)).displayAnimationState.m_216984_()) {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
        }
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.golem.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.golem;
    }
}

