/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.google.common.collect.ImmutableList;
import com.kaboomroads.lostfeatures.entity.ai.ModSensorType;
import com.kaboomroads.lostfeatures.entity.ai.goal.BarnacleAttackGoal;
import com.kaboomroads.lostfeatures.mixin.SquidAccessor;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Barnacle
extends Squid {
    public final AnimationState impaleAnimationState = new AnimationState();
    public final AnimationState hurtAnimationState = new AnimationState();
    public final AnimationState swimAnimationState = new AnimationState();
    public boolean animating = false;
    public boolean swim = false;
    public int animateTicks = 0;
    public Entity lookTarget = null;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Barnacle>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, ModSensorType.BARNACLE_ATTACKABLES_SENSOR.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_);
    private static final EntityDataAccessor<Integer> LOOK_TARGET = SynchedEntityData.m_135353_(Barnacle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final float ATTACK_REACH_SQR = 36.0f;

    public Barnacle(EntityType<? extends Squid> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Squid.m_29988_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22283_).m_22268_(Attributes.f_22281_, 6.0);
    }

    @NotNull
    protected Brain.Provider<Barnacle> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    public Brain<Barnacle> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOOK_TARGET, (Object)-1);
    }

    public int getLookTarget() {
        return (Integer)this.f_19804_.m_135370_(LOOK_TARGET);
    }

    public void setLookTarget(int lookTarget) {
        this.f_19804_.m_135381_(LOOK_TARGET, (Object)lookTarget);
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 64: {
                this.impaleAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 65: {
                this.hurtAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 66: {
                this.swimAnimationState.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (super.m_6469_(damageSource, damage)) {
            this.m_9236_().m_7605_((Entity)this, (byte)65);
            return true;
        }
        return false;
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("barnacleBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6274_().m_21952_(MemoryModuleType.f_148194_).isPresent() && Sensor.m_148312_((LivingEntity)this, (LivingEntity)((LivingEntity)this.m_6274_().m_21952_(MemoryModuleType.f_148194_).get()))) {
            this.m_6710_((LivingEntity)this.m_6274_().m_21952_(MemoryModuleType.f_148194_).get());
        } else {
            this.m_6710_(null);
        }
        this.lookTarget = this.m_9236_().m_6815_(this.getLookTarget());
        if (this.lookTarget != null) {
            Vec3 pos = this.lookTarget.m_20182_();
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(pos.f_82479_, this.lookTarget.m_20191_().m_82399_().f_82480_, pos.f_82481_));
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.swim && ((SquidAccessor)((Object)this)).getSpeed() == 1.0f) {
            this.swim = true;
            this.m_9236_().m_7605_((Entity)this, (byte)66);
        } else if (this.swim && ((SquidAccessor)((Object)this)).getSpeed() < 1.0f) {
            this.swim = false;
        }
        if (this.m_5448_() == null || !this.animating && this.m_5448_().m_20280_((Entity)this) >= 46.0 || this.m_5448_().m_20280_((Entity)this) < 1.0) {
            this.setLookTarget(-1);
        } else if (this.animating && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) >= 1.0) {
            this.setLookTarget(this.m_5448_().m_19879_());
        }
        if (!this.animating) {
            return;
        }
        if (this.m_5448_() != null) {
            if (this.animateTicks == 16 && this.m_5448_().m_20159_()) {
                this.m_5448_().m_8127_();
            }
            if (this.animateTicks >= 16 && this.m_5448_().m_20280_((Entity)this) <= 46.0) {
                Vec3 vec = this.m_20182_().m_82546_(this.m_5448_().m_20182_()).m_82541_();
                this.m_5448_().m_20256_(vec.m_82542_(0.2, 0.2, 0.2));
                this.m_5448_().f_19864_ = true;
            }
            if (this.animateTicks == 38 && this.m_5448_().m_20280_((Entity)this) <= 9.0) {
                this.m_7327_((Entity)this.m_5448_());
            }
        }
        if (++this.animateTicks >= 40) {
            this.animating = false;
            this.animateTicks = 0;
        }
    }

    public void m_7618_(EntityAnchorArgument.Anchor anchor, Vec3 target) {
        Vec3 vec3 = anchor.m_90377_((Entity)this);
        double dx = target.f_82479_ - vec3.f_82479_;
        double dy = target.f_82480_ - vec3.f_82480_;
        double dz = target.f_82481_ - vec3.f_82481_;
        double sqrt = Math.sqrt(dx * dx + dz * dz);
        this.m_146926_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)dy, (double)sqrt) * 57.2957763671875 - 90.0))));
        this.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)dz, (double)dx) * 57.2957763671875) - 90.0f)));
        this.m_5616_(this.m_146908_());
        this.f_29938_ = this.m_146909_();
        this.f_20883_ = this.f_20885_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BarnacleAttackGoal(this, 60, 36.0, 1.0, 2.0, true, false, entity -> {
            this.m_9236_().m_7605_((Entity)this, (byte)64);
            this.animating = true;
        }));
        this.f_21345_.m_25352_(1, (Goal)new OceanDepthsMonsterRandomMovementGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static class OceanDepthsMonsterRandomMovementGoal
    extends Goal {
        private final Squid squid;

        public OceanDepthsMonsterRandomMovementGoal(Squid $$0) {
            this.squid = $$0;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.squid.m_5448_() != null) {
                return;
            }
            int $$0 = this.squid.m_21216_();
            if ($$0 > 100) {
                this.squid.m_29958_(0.0f, 0.0f, 0.0f);
            } else if (this.squid.m_217043_().m_188503_(OceanDepthsMonsterRandomMovementGoal.m_186073_((int)50)) == 0 || !this.squid.m_20069_() || !this.squid.m_29981_()) {
                float $$1 = this.squid.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float $$2 = Mth.m_14089_((float)$$1) * 0.2f;
                float $$3 = -0.1f + this.squid.m_217043_().m_188501_() * 0.2f;
                float $$4 = Mth.m_14031_((float)$$1) * 0.2f;
                this.squid.m_29958_($$2, $$3, $$4);
            }
        }
    }
}

