/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.worldgen.custom;

import com.kaboomroads.lostfeatures.worldgen.configuration.TermiteNestConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class TermiteNestFeature
extends Feature<TermiteNestConfiguration> {
    public TermiteNestFeature(Codec<TermiteNestConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<TermiteNestConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        TermiteNestConfiguration config = (TermiteNestConfiguration)context.m_159778_();
        while (pos.m_123342_() > level.m_141937_() + 3) {
            BlockState state = level.m_8055_(pos.m_7495_());
            if (state.m_204341_(config.canNotGenerateOn())) {
                return false;
            }
            if (state.m_204341_(config.canGenerateOn())) break;
            pos = pos.m_7495_();
        }
        if (pos.m_123342_() <= level.m_141937_() + 3) {
            return false;
        }
        int xSize = config.xSize().m_214085_(random);
        int zSize = config.zSize().m_214085_(random);
        float spireChance = config.spireChance().m_214084_(random);
        int maxSpireCount = config.maxSpireCount().m_214085_(random);
        TermiteNestFeature.generateNest(level, pos, xSize, zSize, config.height(), config.depth(), config.stateProvider(), config.spireProvider(), spireChance, maxSpireCount, config.lastResortSpire(), config.core(), config.coreProvider(), random);
        return true;
    }

    public static void generateNest(WorldGenLevel level, BlockPos center, int xSize, int zSize, IntProvider height, IntProvider depth, BlockStateProvider stateProvider, BlockStateProvider spireProvider, float spireChance, int maxSpireCount, boolean lastResortSpire, boolean core, BlockStateProvider coreProvider, RandomSource random) {
        int deltaX = Mth.m_14143_((float)((float)xSize * 0.5f));
        int deltaZ = Mth.m_14143_((float)((float)zSize * 0.5f));
        BlockPos.MutableBlockPos cursor = center.m_122032_();
        int spires = 0;
        boolean b = false;
        xSize *= 2;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                int ySize = height.m_214085_(random);
                int yDepth = depth.m_214085_(random);
                BlockPos.MutableBlockPos pos = cursor.m_7918_(z - deltaX, -yDepth, z - deltaZ).m_122032_();
                for (int y = 0; y < ySize; ++y) {
                    level.m_7731_((BlockPos)pos, core && pos.equals((Object)center) ? coreProvider.m_213972_(random, (BlockPos)pos) : stateProvider.m_213972_(random, (BlockPos)pos), 4);
                    pos.m_122184_(0, 1, 0);
                    if (spires >= maxSpireCount) continue;
                    if (y >= ySize - 1 && random.m_188501_() <= spireChance) {
                        ++spires;
                        level.m_7731_((BlockPos)pos, spireProvider.m_213972_(random, (BlockPos)pos), 4);
                        continue;
                    }
                    if (!lastResortSpire || spires > 0 || x < xSize - 1) continue;
                    level.m_7731_((BlockPos)pos, spireProvider.m_213972_(random, (BlockPos)pos), 4);
                }
            }
            cursor.m_122184_(b ? 0 : 1, 0, b ? -1 : 0);
            b = !b;
        }
    }
}

