/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.ai.behaviour;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterestingBlockSensor
extends class_4148<class_1309> {
    private final Predicate<class_2680> targetType;
    private final boolean nextTo;
    private final int xRange;
    private final int yRangeN;
    private final int yRangeP;
    private final int zRange;
    private final int memoryDuration;
    private final class_4140<class_2338> memoryType;
    @Nullable
    private final class_4140<class_2338> originalBlockMemory;

    public InterestingBlockSensor(int interval, Predicate<class_2680> targetType, boolean nextTo, int xRange, int yRangeN, int yRangeP, int zRange, int memoryDuration, class_4140<class_2338> memoryType, @Nullable class_4140<class_2338> originalBlockMemory) {
        super(interval);
        this.targetType = targetType;
        this.nextTo = nextTo;
        this.xRange = xRange;
        this.yRangeN = yRangeN;
        this.yRangeP = yRangeP;
        this.zRange = zRange;
        this.memoryDuration = memoryDuration;
        this.memoryType = memoryType;
        this.originalBlockMemory = originalBlockMemory;
    }

    @NotNull
    public Set<class_4140<?>> method_19099() {
        return ImmutableSet.of(this.memoryType);
    }

    protected void method_19101(@NotNull class_3218 serverLevel, class_1309 livingEntity) {
        class_4095 brain = livingEntity.method_18868();
        Optional blockPosition = brain.method_18904(this.memoryType);
        if (blockPosition.isEmpty()) {
            Optional<class_2338> blockPos = InterestingBlockSensor.findBlock(serverLevel, this.targetType, livingEntity, this.xRange, this.yRangeN, this.yRangeP, this.zRange);
            class_2338 pos = blockPos.orElse(null);
            if (this.originalBlockMemory != null) {
                brain.method_18878(this.originalBlockMemory, (Object)pos);
            }
            if (this.nextTo && pos != null) {
                ArrayList possibleDirs = Arrays.stream(class_2350.values()).filter((Predicate<class_2350>)class_2350.class_2353.field_11062).collect(Collectors.toCollection(ArrayList::new));
                class_2338 finalPos = pos;
                possibleDirs.removeIf(dir -> !serverLevel.method_8320(finalPos.method_10093(dir)).method_26215());
                if (!possibleDirs.isEmpty()) {
                    class_2350 direction = (class_2350)possibleDirs.get(livingEntity.method_6051().method_43048(possibleDirs.size()));
                    pos = pos.method_10093(direction);
                }
            }
            if (blockPos.isPresent()) {
                InterestingBlockSensor.setInterestingBlockLocation(livingEntity, this.memoryType, this.memoryDuration, pos);
            }
        } else if (!this.targetType.test(serverLevel.method_8320((class_2338)blockPosition.get()))) {
            InterestingBlockSensor.setInterestingBlockLocation(livingEntity, this.memoryType, this.memoryDuration, null);
        }
    }

    private static Optional<class_2338> findBlock(class_3218 serverLevel, Predicate<class_2680> targetType, class_1309 livingEntity, int xRange, int yRangeN, int yRangeP, int zRange) {
        class_2338 blockPos = livingEntity.method_24515();
        LinkedList<class_2338> positions = new LinkedList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)blockPos.method_10069(-xRange, -yRangeN, -zRange), (class_2338)blockPos.method_10069(xRange, yRangeP, zRange))) {
            if (!targetType.test(serverLevel.method_8320(pos))) continue;
            positions.add(pos.method_10062());
        }
        if (!positions.isEmpty()) {
            return Optional.ofNullable((class_2338)positions.get(livingEntity.method_6051().method_43048(positions.size())));
        }
        return Optional.empty();
    }

    public static void setInterestingBlockLocation(class_1309 entity, class_4140<class_2338> memoryType, int memoryDuration, @Nullable class_2338 blockPos) {
        class_4095 brain = entity.method_18868();
        if (blockPos != null && entity.field_6002.method_8621().method_11952(blockPos)) {
            brain.method_24525(class_4140.field_18446, (Object)new class_4099(blockPos), (long)memoryDuration);
            brain.method_24525(memoryType, (Object)blockPos, (long)memoryDuration);
            brain.method_18875(class_4140.field_18445);
        } else if (blockPos == null) {
            brain.method_18875(memoryType);
            brain.method_18875(class_4140.field_18446);
            brain.method_18875(class_4140.field_18445);
        }
    }
}

