/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.ai.goal;

import com.kaboomroads.lostfeatures.entity.custom.Barnacle;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class BarnacleAttackGoal
extends class_1352 {
    protected final Barnacle mob;
    protected final double speedModifier;
    protected double extraReach;
    protected final boolean followingTargetEvenIfNotSeen;
    protected double pathedTargetX;
    protected double pathedTargetY;
    protected double pathedTargetZ;
    protected double minDistanceSqr;
    protected int ticksUntilNextPathRecalculation;
    protected int ticksUntilNextAttack;
    protected int attackInterval;
    protected long lastCanUseCheck;
    protected boolean wallCheck;
    protected Consumer<class_1309> onDamage;

    public BarnacleAttackGoal(Barnacle mob, int attackInterval, double extraReach, double speedModifier, double minDistanceSqr, boolean wallCheck, boolean followTargetEvenIfNotSeen, @Nullable Consumer<class_1309> onDamage) {
        this.mob = mob;
        this.attackInterval = attackInterval;
        this.extraReach = extraReach;
        this.speedModifier = speedModifier;
        this.minDistanceSqr = minDistanceSqr;
        this.wallCheck = wallCheck;
        this.followingTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.onDamage = onDamage;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        long gameTime = this.mob.field_6002.method_8510();
        if (gameTime - this.lastCanUseCheck < (long)this.attackInterval) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        class_1309 target = this.mob.method_5968();
        if (target == null) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        return this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321()) <= this.mob.method_5996(class_5134.field_23717).method_6194();
    }

    public boolean method_6266() {
        class_1309 target = this.mob.method_5968();
        if (target == null) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        if (!this.mob.method_18407(target.method_24515())) {
            return false;
        }
        return !(target instanceof class_1657) || !target.method_7325() && !((class_1657)target).method_7337();
    }

    public void method_6269() {
        this.mob.method_19540(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void method_6270() {
        class_1309 target = this.mob.method_5968();
        if (!class_1301.field_6156.test(target)) {
            this.mob.method_5980(null);
        }
        this.mob.method_19540(false);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target != null) {
            this.mob.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            double distSqr = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.method_5985().method_6369((class_1297)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.method_5649(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= this.minDistanceSqr || this.mob.method_6051().method_43057() < 0.05f)) {
                int $$0 = this.mob.method_6131();
                if ($$0 > 100) {
                    this.mob.method_6670(0.0f, 0.0f, 0.0f);
                } else if (this.mob.method_6051().method_43048(BarnacleAttackGoal.method_38848((int)20)) == 0 || !this.mob.method_5799() || !this.mob.method_6672()) {
                    class_243 v = this.mob.method_5968().method_19538().method_1020(this.mob.method_19538()).method_1029().method_18805(0.2, 0.2, 0.2);
                    this.mob.method_6670((float)v.field_1352, (float)v.field_1351, (float)v.field_1350);
                }
            }
            this.ticksUntilNextAttack = Math.max(this.getTicksUntilNextAttack() - 1, 0);
            this.checkAndPerformAttack(target, distSqr);
        }
    }

    protected void checkAndPerformAttack(class_1309 entity, double distSqr) {
        double attackReachSqr = this.getAttackReachSqr(entity);
        if (distSqr <= attackReachSqr + this.extraReach && this.isTimeToAttack() && (!this.wallCheck || this.mob.method_6057((class_1297)entity))) {
            this.resetAttackCooldown();
            if (this.onDamage != null) {
                this.onDamage.accept(entity);
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.getAttackInterval();
    }

    protected boolean isTimeToAttack() {
        return this.getTicksUntilNextAttack() <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.method_38847(this.attackInterval);
    }

    protected double getAttackReachSqr(class_1309 entity) {
        return this.mob.method_17681() * 2.0f * this.mob.method_17681() * 2.0f + entity.method_17681();
    }
}

