/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.kaboomroads.lostfeatures.mixin.BlazeAccessor;
import java.util.EnumSet;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1545;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import org.jetbrains.annotations.NotNull;

public class Wildfire
extends class_1545 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 hurtAnimationState = new class_7094();
    private static final class_2940<Integer> SHIELDS = class_2945.method_12791(Wildfire.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHIELD_REGENERATION = class_2945.method_12791(Wildfire.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHIELD_REGENERATING = class_2945.method_12791(Wildfire.class, (class_2941)class_2943.field_13323);
    public static final int SHEILD_REGEN_START_TIME = 60;
    public static final int SHEILD_REGEN_TIME = 40;

    public Wildfire(class_1299<? extends class_1545> entityType, class_1937 level) {
        super(entityType, level);
        this.idleAnimationState.method_41324(this.field_6012);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHIELDS, (Object)4);
        this.field_6011.method_12784(SHIELD_REGENERATION, (Object)0);
        this.field_6011.method_12784(SHIELD_REGENERATING, (Object)false);
    }

    public int getShields() {
        return (Integer)this.field_6011.method_12789(SHIELDS);
    }

    public void setShields(int shields) {
        this.field_6011.method_12778(SHIELDS, (Object)shields);
    }

    public int getShieldRegeneration() {
        return (Integer)this.field_6011.method_12789(SHIELD_REGENERATION);
    }

    public void setShieldRegeneration(int shieldRegeneration) {
        this.field_6011.method_12778(SHIELD_REGENERATION, (Object)shieldRegeneration);
    }

    public boolean getShieldRegenerating() {
        return (Boolean)this.field_6011.method_12789(SHIELD_REGENERATING);
    }

    public void setShieldRegenerating(boolean shieldRegenerating) {
        this.field_6011.method_12778(SHIELD_REGENERATING, (Object)shieldRegenerating);
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1545.method_26906().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23721, 8.0);
    }

    public void method_5711(byte id) {
        if (id == 64) {
            this.hurtAnimationState.method_41322(this.field_6012);
        } else {
            super.method_5711(id);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.field_6002.field_9236) {
            return;
        }
        if (this.getShieldRegenerating()) {
            this.setShieldRegeneration(this.getShieldRegeneration() + 1);
            int shieldRegen = this.getShieldRegeneration();
            if (shieldRegen >= 60 && shieldRegen % 40 == 0) {
                this.setShields(this.getShields() + 1);
                if (this.getShields() >= 4) {
                    this.setShieldRegenerating(false);
                    this.setShieldRegeneration(0);
                }
            }
        }
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        return damageSource.method_5529() != null && damageSource.method_5529().method_5779((class_1297)this) && damageSource.method_5526() instanceof class_1677 || damageSource.method_5534() || super.method_5679(damageSource);
    }

    public boolean method_5643(@NotNull class_1282 damageSource, float damage) {
        float originalDamage = damage;
        if (!damageSource.method_5538()) {
            damage *= 1.0f - (float)this.getShields() / 4.0f;
        }
        if (super.method_5643(damageSource, damage)) {
            if (!this.field_6002.field_9236 && !damageSource.method_5527() && !damageSource.method_33329() && originalDamage >= 3.0f) {
                int shields = this.getShields();
                if (shields > 0) {
                    this.setShields(shields - 1);
                    if (shields <= 4) {
                        this.setShieldRegenerating(true);
                    }
                } else if (shields != 0) {
                    this.setShields(0);
                }
                this.field_6002.method_8421((class_1297)this, (byte)64);
            }
            return true;
        }
        return false;
    }

    protected void method_5959() {
        this.field_6201.method_6277(4, (class_1352)new WildfireAttackGoal(this, 3));
        this.field_6201.method_6277(5, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class WildfireAttackGoal
    extends class_1352 {
        private final class_1545 blaze;
        private int attackStep;
        private int attackTime;
        private int lastSeen;
        private final int burst;

        public WildfireAttackGoal(class_1545 blaze, int burst) {
            this.blaze = blaze;
            this.burst = burst;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.blaze.method_5968();
            return target != null && target.method_5805() && this.blaze.method_18395(target);
        }

        public void method_6269() {
            this.attackStep = 0;
        }

        public void method_6270() {
            ((BlazeAccessor)this.blaze).invokeSetCharged(false);
            this.lastSeen = 0;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            --this.attackTime;
            class_1309 target = this.blaze.method_5968();
            if (target != null) {
                boolean hasLineOfSight = this.blaze.method_5985().method_6369((class_1297)target);
                this.lastSeen = hasLineOfSight ? 0 : ++this.lastSeen;
                double distanceSqr = this.blaze.method_5858((class_1297)target);
                if (distanceSqr < 4.0) {
                    if (!hasLineOfSight) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blaze.method_6121((class_1297)target);
                    }
                    this.blaze.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                } else if (distanceSqr < this.getFollowDistance() * this.getFollowDistance() && hasLineOfSight) {
                    double dx = target.method_23317() - this.blaze.method_23317();
                    double dy = target.method_23323(0.5) - this.blaze.method_23323(0.5);
                    double dz = target.method_23321() - this.blaze.method_23321();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            ((BlazeAccessor)this.blaze).invokeSetCharged(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            ((BlazeAccessor)this.blaze).invokeSetCharged(false);
                        }
                        if (this.attackStep > 1) {
                            double distanceSqrt = Math.sqrt(Math.sqrt(distanceSqr)) * 0.5;
                            if (!this.blaze.method_5701()) {
                                this.blaze.field_6002.method_8444(null, 1018, this.blaze.method_24515(), 0);
                            }
                            for (int i = 0; i < this.burst; ++i) {
                                class_1677 fireball = new class_1677(this.blaze.field_6002, (class_1309)this.blaze, this.blaze.method_6051().method_43385(dx, 1.5 * distanceSqrt), dy, this.blaze.method_6051().method_43385(dz, 1.5 * distanceSqrt));
                                fireball.method_5814(fireball.method_23317(), this.blaze.method_23323(0.5) + 0.5, fireball.method_23321());
                                this.blaze.field_6002.method_8649((class_1297)fireball);
                            }
                        }
                    }
                    this.blaze.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.blaze.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowDistance() {
            return this.blaze.method_26825(class_5134.field_23717);
        }
    }
}

