/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.worldgen.tree;

import com.google.common.collect.Lists;
import com.kaboomroads.lostfeatures.worldgen.ModTrunkPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class BaobabTrunkPlacer
extends class_5141 {
    public static final Codec<BaobabTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group(BaobabTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).t1(), BaobabTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).t2(), BaobabTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).t3(), (App)Codec.intRange((int)1, (int)32).fieldOf("base_width").forGetter(trunkPlacer -> trunkPlacer.baseWidth), (App)class_6017.field_33450.fieldOf("branch_seperation").forGetter(trunkPlacer -> trunkPlacer.branchSeperation), (App)class_6017.field_33451.fieldOf("branch_length").forGetter(trunkPlacer -> trunkPlacer.branchLength), (App)class_6017.field_33450.fieldOf("upward_branch_length").forGetter(trunkPlacer -> trunkPlacer.upwardBranchLength), (App)Codec.intRange((int)0, (int)32).fieldOf("branch_height_min").forGetter(trunkPlacer -> trunkPlacer.minBranchHeight), (App)Codec.intRange((int)0, (int)32).fieldOf("branch_height_max").forGetter(trunkPlacer -> trunkPlacer.maxBranchHeight), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability))).apply((Applicative)instance, BaobabTrunkPlacer::new));
    private final class_6017 branchLength;
    private final float placeBranchPerLogProbability;
    private final class_6017 upwardBranchLength;
    protected final class_6017 branchSeperation;
    protected final int baseWidth;
    protected final int minBranchHeight;
    protected final int maxBranchHeight;

    public BaobabTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int baseWidth, class_6017 branchSeperation, class_6017 branchLength, class_6017 upwardBranchLength, int minBranchHeight, int maxBranchHeight, float branchProbability) {
        super(baseHeight, heightRandA, heightRandB);
        this.baseWidth = baseWidth;
        this.branchSeperation = branchSeperation;
        this.branchLength = branchLength;
        this.upwardBranchLength = upwardBranchLength;
        this.minBranchHeight = minBranchHeight;
        this.maxBranchHeight = maxBranchHeight;
        this.placeBranchPerLogProbability = branchProbability;
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return ModTrunkPlacerTypes.BAOBAB_TRUNK_PLACER.get();
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 reader, @NotNull BiConsumer<class_2338, class_2680> biConsumer, @NotNull class_5819 random, int height, @NotNull class_2338 pos, @NotNull class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338 below = pos.method_10074();
        int offset = class_3532.method_15375((float)((float)this.baseWidth / -2.0f)) + 1;
        class_2338 dirtStartPos = below.method_10069(offset, 0, offset);
        class_2338 dirtEndPos = dirtStartPos.method_10069(this.baseWidth - 1, 0, this.baseWidth - 1);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)dirtStartPos, (class_2338)dirtEndPos)) {
            BaobabTrunkPlacer.method_27400((class_3746)reader, biConsumer, (class_5819)random, (class_2338)blockPos, (class_4643)config);
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int lastBranchPos = Integer.MIN_VALUE;
        for (int current = 0; current < height; ++current) {
            int j = pos.method_10264() + current;
            mutablePos.method_10103(pos.method_10263(), j, pos.method_10260());
            class_2338 startPos = mutablePos.method_10062().method_10069(offset, 0, offset);
            class_2338 endPos = startPos.method_10069(this.baseWidth - 1, 0, this.baseWidth - 1);
            ArrayList<class_2338> possiblePositions = new ArrayList<class_2338>(this.baseWidth * this.baseWidth - (this.baseWidth - 2) * (this.baseWidth - 2));
            for (class_2338 blockPos : class_2338.method_10097((class_2338)startPos, (class_2338)endPos)) {
                this.method_35375(reader, biConsumer, random, blockPos, config);
                if (blockPos.method_10263() != startPos.method_10263() && blockPos.method_10263() != endPos.method_10263() && blockPos.method_10260() != startPos.method_10260() && blockPos.method_10260() != endPos.method_10260()) continue;
                possiblePositions.add(blockPos.method_10062());
            }
            class_2338.class_2339 branchPos = ((class_2338)possiblePositions.get(random.method_43048(possiblePositions.size()))).method_25503();
            int sample = this.branchSeperation.method_35008(random);
            if (current >= lastBranchPos + sample && current < height - this.maxBranchHeight && current >= this.minBranchHeight && random.method_43057() < this.placeBranchPerLogProbability) {
                lastBranchPos = current;
                class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
                int upwardLength = this.upwardBranchLength.method_35008(random);
                int length = this.branchLength.method_35008(random);
                this.placeBranch(reader, biConsumer, random, config, list, branchPos, direction, length, upwardLength);
            }
            if (current != height - 1) continue;
            list.add(new class_4647.class_5208((class_2338)mutablePos.method_10103(pos.method_10263(), j + 1, pos.method_10260()), 0, false));
        }
        return list;
    }

    private void placeBranch(class_3746 reader, BiConsumer<class_2338, class_2680> biConsumer, class_5819 random, class_4643 config, List<class_4647.class_5208> foliage, class_2338.class_2339 mutablePos, class_2350 direction, int length, int upwardLength) {
        int i;
        class_2338.class_2339 current = mutablePos.method_25503();
        for (i = 0; i < length; ++i) {
            current.method_10098(direction);
            this.method_27402(reader, biConsumer, random, (class_2338)current, config, state -> (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()));
        }
        for (i = 0; i < upwardLength; ++i) {
            current.method_10098(class_2350.field_11036);
            this.method_35375(reader, biConsumer, random, (class_2338)current, config);
            if (i < upwardLength - 1) continue;
            foliage.add(new class_4647.class_5208(current.method_10069(0, 1, 0).method_10062(), 0, false));
        }
    }
}

