/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.block.custom;

import com.kaboomroads.lostfeatures.block.ModBlocks;
import com.kaboomroads.lostfeatures.block.custom.TermiteNestBlock;
import com.kaboomroads.lostfeatures.block.entity.custom.TermiteNestCoreBlockEntity;
import com.kaboomroads.lostfeatures.tag.ModTags;
import com.kaboomroads.lostfeatures.worldgen.ModConfiguredFeatures;
import com.kaboomroads.lostfeatures.worldgen.configuration.TermiteNestConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TermiteNestCoreBlock
extends BaseEntityBlock {
    public TermiteNestCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_142387_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        super.m_142387_(level, player, blockPos, blockState);
        TermiteNestBlock.spawnTermites(level, blockPos, dir -> true, (IntProvider)UniformInt.m_146622_((int)7, (int)10), (pos, vec) -> new Vec3(0.0, -0.01, 0.0), Vec3.f_82478_, 0.25);
    }

    public void m_214162_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        super.m_214162_(blockState, level, blockPos, random);
        this.spawnParticles(level, blockPos);
    }

    protected void spawnParticles(@NotNull Level level, @NotNull BlockPos blockPos) {
        TermiteNestBlock.spawnTermites(level, blockPos, dir -> !level.m_8055_(blockPos.m_121945_(dir)).m_60838_((BlockGetter)level, blockPos), (IntProvider)UniformInt.m_146622_((int)1, (int)2), null, Vec3.f_82478_, 0.55);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TermiteNestCoreBlockEntity(blockPos, blockState);
    }

    public boolean m_6724_(@NotNull BlockState blockState) {
        return true;
    }

    public void m_213898_(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        super.m_213898_(blockState, level, blockPos, random);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof TermiteNestCoreBlockEntity) {
            Object featureKey;
            Registry registry;
            Optional optional;
            TermiteNestCoreBlockEntity blockEntity2 = (TermiteNestCoreBlockEntity)blockEntity;
            if (blockEntity2.largerNest == null && (optional = (registry = level.m_7654_().m_206579_().m_175515_(Registries.f_256911_)).m_203636_(featureKey = ModConfiguredFeatures.LARGE_TERMITE_NEST)).isPresent()) {
                ConfiguredFeature feature = (ConfiguredFeature)((Holder.Reference)optional.get()).m_203334_();
                TermiteNestConfiguration config = (TermiteNestConfiguration)feature.f_65378_();
                int xSize = config.xSize().m_214085_(random);
                int zSize = config.zSize().m_214085_(random);
                float spireChance = config.spireChance().m_214084_(random);
                int maxSpireCount = config.maxSpireCount().m_214085_(random);
                blockEntity2.largerNest = TermiteNestCoreBlock.generateNest(blockPos, xSize, zSize, config.height(), config.depth(), config.stateProvider(), config.spireProvider(), spireChance, maxSpireCount, config.lastResortSpire(), config.core(), config.coreProvider(), blockEntity2.types, random);
            }
            if (blockEntity2.largerNest != null) {
                HashMap<BlockPos, BlockState> nest = new HashMap<BlockPos, BlockState>();
                block0: for (Map.Entry entry : blockEntity2.largerNest.entrySet()) {
                    BlockState state = level.m_8055_((BlockPos)entry.getKey());
                    if (!state.m_60710_((LevelReader)level, (BlockPos)entry.getKey()) || state.m_204336_(ModTags.Blocks.TERMITE_NEST_CAN_NOT_GENERATE) || blockEntity2.types.contains(state) && !state.m_60713_(ModBlocks.TERMITE_SPIRES.get()) || !state.m_60795_() && !state.m_247087_() && !state.m_204336_(ModTags.Blocks.TERMITE_NEST_CAN_GENERATE) && !state.m_60713_(ModBlocks.TERMITE_SPIRES.get())) continue;
                    for (Direction direction : Direction.values()) {
                        BlockState relativeState = level.m_8055_(((BlockPos)entry.getKey()).m_121945_(direction));
                        if (relativeState.m_204336_(ModTags.Blocks.TERMITE_NEST_CAN_NOT_GENERATE) || relativeState.m_60795_() || relativeState.m_247087_() || relativeState.m_60713_(ModBlocks.TERMITE_SPIRES.get())) continue;
                        nest.put((BlockPos)entry.getKey(), (BlockState)entry.getValue());
                        continue block0;
                    }
                }
                if (!nest.isEmpty()) {
                    Object[] entryArray = nest.entrySet().toArray();
                    Map.Entry entry = (Map.Entry)entryArray[random.m_188503_(entryArray.length)];
                    level.m_7731_((BlockPos)entry.getKey(), (BlockState)entry.getValue(), 3);
                    blockEntity2.largerNest.remove(entry.getKey());
                    if (nest.size() <= 1) {
                        level.m_7731_(blockPos, (BlockState)ModBlocks.TERMITE_NEST.get().m_49966_().m_61124_((Property)TermiteNestBlock.TERMITES, (Comparable)Boolean.valueOf(true)), 3);
                    }
                }
            }
        }
    }

    public static HashMap<BlockPos, BlockState> generateNest(BlockPos center, int xSize, int zSize, IntProvider height, IntProvider depth, BlockStateProvider stateProvider, BlockStateProvider spireProvider, float spireChance, int maxSpireCount, boolean lastResortSpire, boolean core, BlockStateProvider coreProvider, List<BlockState> types, RandomSource random) {
        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
        int deltaX = Mth.m_14143_((float)((float)xSize * 0.75f));
        int deltaZ = Mth.m_14143_((float)((float)zSize * 0.25f));
        BlockPos.MutableBlockPos cursor = center.m_122032_();
        int spires = 0;
        boolean b = false;
        xSize *= 2;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                int ySize = height.m_214085_(random);
                int yDepth = depth.m_214085_(random);
                BlockPos.MutableBlockPos pos = cursor.m_7918_(z - deltaX, -yDepth, z - deltaZ).m_122032_();
                for (int y = 0; y < ySize; ++y) {
                    BlockState spireState;
                    BlockState state = core && pos.equals((Object)center) ? coreProvider.m_213972_(random, (BlockPos)pos) : stateProvider.m_213972_(random, (BlockPos)pos);
                    map.put(pos.m_7949_(), state);
                    if (!types.contains(state)) {
                        types.add(state);
                    }
                    pos.m_122184_(0, 1, 0);
                    if (spires >= maxSpireCount) continue;
                    if (y >= ySize - 1 && random.m_188501_() <= spireChance) {
                        ++spires;
                        spireState = spireProvider.m_213972_(random, (BlockPos)pos);
                        map.put(pos.m_7949_(), spireState);
                        if (types.contains(spireState)) continue;
                        types.add(spireState);
                        continue;
                    }
                    if (!lastResortSpire || spires > 0 || x < xSize - 1) continue;
                    spireState = spireProvider.m_213972_(random, (BlockPos)pos);
                    map.put(pos.m_7949_(), spireState);
                    if (types.contains(spireState)) continue;
                    types.add(spireState);
                }
            }
            cursor.m_122184_(b ? 0 : 1, 0, b ? -1 : 0);
            b = !b;
        }
        return map;
    }
}

