/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.block.entity.custom;

import com.kaboomroads.lostfeatures.damagesource.ModDamageSource;
import com.kaboomroads.lostfeatures.gameevent.ModGameEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SculkAttacker {
    public static final VoxelShape ATTACK_SHAPE_DEFAULT = Block.m_49796_((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0);
    public static final LinkedList<EntityType<?>> NON_ATTACKABLE = new LinkedList<EntityType>(List.of(EntityType.f_217015_));

    public static List<LivingEntity> getAttackEntities(Level level, SculkAttacker sculkAttacker) {
        return SculkAttacker.getAttackEntities(level, sculkAttacker.getAttackShape(), new Vec3(sculkAttacker.getLevelX(), sculkAttacker.getLevelY(), sculkAttacker.getLevelZ()));
    }

    public static List<LivingEntity> getAttackEntities(Level level, VoxelShape shape, Vec3 pos) {
        return shape.m_83299_().stream().flatMap(aabb -> level.m_6443_(LivingEntity.class, aabb.m_82386_(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    public static void sculkDamage(LivingEntity livingEntity) {
        if (livingEntity.m_6095_() == EntityType.f_20532_) {
            livingEntity.f_19802_ = 0;
        }
        livingEntity.m_6469_(ModDamageSource.SCULK_ATTACK, 10.0f);
        livingEntity.f_19853_.m_214171_(ModGameEvent.SCULK_ATTACK.get(), livingEntity.m_20182_(), GameEvent.Context.m_223717_((Entity)livingEntity));
    }

    default public VoxelShape getAttackShape() {
        return ATTACK_SHAPE_DEFAULT;
    }

    public static boolean testAttackable(Entity entity) {
        return entity != null && !NON_ATTACKABLE.contains(entity.m_6095_());
    }

    public double getLevelX();

    public double getLevelY();

    public double getLevelZ();
}

