/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.ai.goal;

import com.kaboomroads.lostfeatures.entity.custom.Barnacle;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BarnacleAttackGoal
extends Goal {
    protected final Barnacle mob;
    protected final double speedModifier;
    protected double extraReach;
    protected final boolean followingTargetEvenIfNotSeen;
    protected double pathedTargetX;
    protected double pathedTargetY;
    protected double pathedTargetZ;
    protected double minDistanceSqr;
    protected int ticksUntilNextPathRecalculation;
    protected int ticksUntilNextAttack;
    protected int attackInterval;
    protected long lastCanUseCheck;
    protected boolean wallCheck;
    protected Consumer<LivingEntity> onDamage;

    public BarnacleAttackGoal(Barnacle mob, int attackInterval, double extraReach, double speedModifier, double minDistanceSqr, boolean wallCheck, boolean followTargetEvenIfNotSeen, @Nullable Consumer<LivingEntity> onDamage) {
        this.mob = mob;
        this.attackInterval = attackInterval;
        this.extraReach = extraReach;
        this.speedModifier = speedModifier;
        this.minDistanceSqr = minDistanceSqr;
        this.wallCheck = wallCheck;
        this.followingTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.onDamage = onDamage;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long gameTime = this.mob.f_19853_.m_46467_();
        if (gameTime - this.lastCanUseCheck < (long)this.attackInterval) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        return this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()) <= this.mob.m_21051_(Attributes.f_22277_).m_22135_();
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.mob.m_21444_(target.m_20183_())) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distSqr = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= this.minDistanceSqr || this.mob.m_217043_().m_188501_() < 0.05f)) {
                int $$0 = this.mob.m_21216_();
                if ($$0 > 100) {
                    this.mob.m_29958_(0.0f, 0.0f, 0.0f);
                } else if (this.mob.m_217043_().m_188503_(BarnacleAttackGoal.m_186073_((int)20)) == 0 || !this.mob.m_20069_() || !this.mob.m_29981_()) {
                    Vec3 v = this.mob.m_5448_().m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82542_(0.2, 0.2, 0.2);
                    this.mob.m_29958_((float)v.f_82479_, (float)v.f_82480_, (float)v.f_82481_);
                }
            }
            this.ticksUntilNextAttack = Math.max(this.getTicksUntilNextAttack() - 1, 0);
            this.checkAndPerformAttack(target, distSqr);
        }
    }

    protected void checkAndPerformAttack(LivingEntity entity, double distSqr) {
        double attackReachSqr = this.getAttackReachSqr(entity);
        if (distSqr <= attackReachSqr + this.extraReach && this.isTimeToAttack() && (!this.wallCheck || this.mob.m_142582_((Entity)entity))) {
            this.resetAttackCooldown();
            if (this.onDamage != null) {
                this.onDamage.accept(entity);
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.getAttackInterval();
    }

    protected boolean isTimeToAttack() {
        return this.getTicksUntilNextAttack() <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(this.attackInterval);
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }
}

