/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.client.tuffgolem;

import com.kaboomroads.lostfeatures.entity.client.tuffgolem.TuffGolemModel;
import com.kaboomroads.lostfeatures.entity.custom.TuffGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TuffGolemRenderer<T extends TuffGolem>
extends MobRenderer<T, TuffGolemModel<T>> {
    private static final ResourceLocation DEFAULT_GOLEM_LOCATION = new ResourceLocation("lostfeatures", "textures/entity/tuff_golem/tuff_golem_red.png");
    private final ItemRenderer itemRenderer;

    public TuffGolemRenderer(EntityRendererProvider.Context context) {
        super(context, new TuffGolemModel(context.m_174023_(TuffGolemModel.LAYER_LOCATION)), 0.5f);
        this.itemRenderer = context.m_174025_();
    }

    public void render(@NotNull T entity, float $$1, float $$2, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_(entity, $$1, $$2, poseStack, bufferSource, packedLight);
        ItemStack item = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (!item.m_41619_()) {
            poseStack.m_85836_();
            Vec3 vec3 = this.m_7860_((Entity)entity, $$2);
            poseStack.m_85837_(-vec3.m_7096_(), -vec3.m_7098_() + 0.59375, -vec3.m_7094_());
            float yaw = (float)Math.toRadians($$1);
            float x = (float)(-Math.sin(yaw));
            float z = (float)Math.cos(yaw);
            poseStack.m_252880_(x * 0.4375f, 0.0f, z * 0.4375f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.m_146908_()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_174269_(item, ItemTransforms.TransformType.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, bufferSource, entity.m_19879_());
            poseStack.m_85849_();
        }
    }

    @Nullable
    protected RenderType getClothRenderType(ResourceLocation $$4, boolean $$1, boolean $$2, boolean $$3) {
        if ($$2) {
            return RenderType.m_110467_((ResourceLocation)$$4);
        }
        if ($$1) {
            return ((TuffGolemModel)this.f_115290_).m_103119_($$4);
        }
        return $$3 ? RenderType.m_110491_((ResourceLocation)$$4) : null;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return ((TuffGolem)((Object)entity)).getClothColor().getTextureLocation();
    }
}

