/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.kaboomroads.lostfeatures.block.ModBlocks;
import com.kaboomroads.lostfeatures.entity.ModEntityTypes;
import com.kaboomroads.lostfeatures.item.ModItems;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModBoat
extends Boat {
    private static final EntityDataAccessor<Integer> CUSTOM_TYPE = SynchedEntityData.m_135353_(ModBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModBoat(EntityType<? extends ModBoat> entityType, Level level) {
        super(entityType, level);
    }

    public ModBoat(Level level, double x, double y, double z) {
        this(ModEntityTypes.BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CUSTOM_TYPE, (Object)Type.BAOBAB.ordinal());
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128425_("Type", 8)) {
            this.setCustomVariant(Type.byName(compoundTag.m_128461_("Type")));
        }
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_("Type", this.getCustomVariant().getName());
    }

    @NotNull
    public Item m_38369_() {
        return switch (this.getCustomVariant()) {
            case Type.BAOBAB -> ModItems.BAOBAB_BOAT.get();
            default -> ModItems.BAOBAB_BOAT.get();
        };
    }

    public void setCustomVariant(Type type) {
        this.f_19804_.m_135381_(CUSTOM_TYPE, (Object)type.ordinal());
    }

    @NotNull
    public Type getCustomVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(CUSTOM_TYPE));
    }

    public static enum Type implements StringRepresentable
    {
        BAOBAB(ModBlocks.BAOBAB_PLANKS.get(), "baobab");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block planks, String name) {
            this.planks = planks;
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            return BY_ID.apply(id);
        }

        public static Type byName(String name) {
            return (Type)CODEC.m_262792_(name, (Enum)BAOBAB);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

