/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.kaboomroads.lostfeatures.mixin.BlazeAccessor;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Wildfire
extends Blaze {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState hurtAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> SHIELDS = SynchedEntityData.m_135353_(Wildfire.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELD_REGENERATION = SynchedEntityData.m_135353_(Wildfire.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHIELD_REGENERATING = SynchedEntityData.m_135353_(Wildfire.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int SHEILD_REGEN_START_TIME = 60;
    public static final int SHEILD_REGEN_TIME = 40;

    public Wildfire(EntityType<? extends Blaze> entityType, Level level) {
        super(entityType, level);
        this.idleAnimationState.m_216982_(this.f_19797_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELDS, (Object)4);
        this.f_19804_.m_135372_(SHIELD_REGENERATION, (Object)0);
        this.f_19804_.m_135372_(SHIELD_REGENERATING, (Object)false);
    }

    public int getShields() {
        return (Integer)this.f_19804_.m_135370_(SHIELDS);
    }

    public void setShields(int shields) {
        this.f_19804_.m_135381_(SHIELDS, (Object)shields);
    }

    public int getShieldRegeneration() {
        return (Integer)this.f_19804_.m_135370_(SHIELD_REGENERATION);
    }

    public void setShieldRegeneration(int shieldRegeneration) {
        this.f_19804_.m_135381_(SHIELD_REGENERATION, (Object)shieldRegeneration);
    }

    public boolean getShieldRegenerating() {
        return (Boolean)this.f_19804_.m_135370_(SHIELD_REGENERATING);
    }

    public void setShieldRegenerating(boolean shieldRegenerating) {
        this.f_19804_.m_135381_(SHIELD_REGENERATING, (Object)shieldRegenerating);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Blaze.m_32238_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    public void m_7822_(byte id) {
        if (id == 64) {
            this.hurtAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.getShieldRegenerating()) {
            this.setShieldRegeneration(this.getShieldRegeneration() + 1);
            int shieldRegen = this.getShieldRegeneration();
            if (shieldRegen >= 60 && shieldRegen % 40 == 0) {
                this.setShields(this.getShields() + 1);
                if (this.getShields() >= 4) {
                    this.setShieldRegenerating(false);
                    this.setShieldRegeneration(0);
                }
            }
        }
    }

    public boolean m_6673_(@NotNull DamageSource damageSource) {
        return damageSource.m_7639_() != null && damageSource.m_7639_().m_7306_((Entity)this) && damageSource.m_7640_() instanceof SmallFireball || damageSource.m_19384_() || super.m_6673_(damageSource);
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        float originalDamage = damage;
        if (!damageSource.m_19378_()) {
            damage *= 1.0f - (float)this.getShields() / 4.0f;
        }
        if (super.m_6469_(damageSource, damage)) {
            if (!this.f_19853_.f_46443_ && !damageSource.m_19387_() && !damageSource.m_146707_() && originalDamage >= 3.0f) {
                int shields = this.getShields();
                if (shields > 0) {
                    this.setShields(shields - 1);
                    if (shields <= 4) {
                        this.setShieldRegenerating(true);
                    }
                } else if (shields != 0) {
                    this.setShields(0);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)64);
            }
            return true;
        }
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new WildfireAttackGoal(this, 3));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static class WildfireAttackGoal
    extends Goal {
        private final Blaze blaze;
        private int attackStep;
        private int attackTime;
        private int lastSeen;
        private final int burst;

        public WildfireAttackGoal(Blaze blaze, int burst) {
            this.blaze = blaze;
            this.burst = burst;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.blaze.m_5448_();
            return target != null && target.m_6084_() && this.blaze.m_6779_(target);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            ((BlazeAccessor)this.blaze).invokeSetCharged(false);
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity target = this.blaze.m_5448_();
            if (target != null) {
                boolean hasLineOfSight = this.blaze.m_21574_().m_148306_((Entity)target);
                this.lastSeen = hasLineOfSight ? 0 : ++this.lastSeen;
                double distanceSqr = this.blaze.m_20280_((Entity)target);
                if (distanceSqr < 4.0) {
                    if (!hasLineOfSight) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blaze.m_7327_((Entity)target);
                    }
                    this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
                } else if (distanceSqr < this.getFollowDistance() * this.getFollowDistance() && hasLineOfSight) {
                    double dx = target.m_20185_() - this.blaze.m_20185_();
                    double dy = target.m_20227_(0.5) - this.blaze.m_20227_(0.5);
                    double dz = target.m_20189_() - this.blaze.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            ((BlazeAccessor)this.blaze).invokeSetCharged(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            ((BlazeAccessor)this.blaze).invokeSetCharged(false);
                        }
                        if (this.attackStep > 1) {
                            double distanceSqrt = Math.sqrt(Math.sqrt(distanceSqr)) * 0.5;
                            if (!this.blaze.m_20067_()) {
                                this.blaze.f_19853_.m_5898_(null, 1018, this.blaze.m_20183_(), 0);
                            }
                            for (int i = 0; i < this.burst; ++i) {
                                SmallFireball fireball = new SmallFireball(this.blaze.f_19853_, (LivingEntity)this.blaze, this.blaze.m_217043_().m_216328_(dx, 1.5 * distanceSqrt), dy, this.blaze.m_217043_().m_216328_(dz, 1.5 * distanceSqrt));
                                fireball.m_6034_(fireball.m_20185_(), this.blaze.m_20227_(0.5) + 0.5, fireball.m_20189_());
                                this.blaze.f_19853_.m_7967_((Entity)fireball);
                            }
                        }
                    }
                    this.blaze.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.blaze.m_21133_(Attributes.f_22277_);
        }
    }
}

