/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.block.custom;

import com.kaboomroads.lostfeatures.particle.ModParticles;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TermiteNestBlock
extends Block {
    public static final BooleanProperty TERMITES = BooleanProperty.m_61465_((String)"termites");

    public TermiteNestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TERMITES, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TERMITES});
    }

    protected void m_142387_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        super.m_142387_(level, player, blockPos, blockState);
        if (((Boolean)blockState.m_61143_((Property)TERMITES)).booleanValue()) {
            TermiteNestBlock.spawnTermites(level, blockPos, dir -> true, (IntProvider)UniformInt.m_146622_((int)7, (int)10), (pos, vec) -> new Vec3(0.0, -0.01, 0.0), Vec3.f_82478_, 0.25);
        }
    }

    public void m_214162_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        super.m_214162_(blockState, level, blockPos, random);
        if (((Boolean)blockState.m_61143_((Property)TERMITES)).booleanValue()) {
            this.spawnParticles(level, blockPos);
        }
    }

    protected void spawnParticles(@NotNull Level level, @NotNull BlockPos blockPos) {
        TermiteNestBlock.spawnTermites(level, blockPos, dir -> !level.m_8055_(blockPos.m_121945_(dir)).m_60838_((BlockGetter)level, blockPos), (IntProvider)UniformInt.m_146622_((int)1, (int)2), null, Vec3.f_82478_, 0.55);
    }

    public static void spawnTermites(@NotNull Level level, @NotNull BlockPos blockPos, Predicate<Direction> predicate, IntProvider amount, @Nullable BiFunction<Vec3, Vec3, Vec3> vecFunction, Vec3 offset, double faceDistance) {
        BiFunction<Vec3, Vec3, Vec3> function = (pos, vec) -> pos.m_82546_(vec).m_82490_((double)0.025f);
        if (vecFunction != null) {
            function = vecFunction;
        }
        for (Direction direction : Direction.values()) {
            if (!predicate.test(direction)) continue;
            TermiteNestBlock.spawnParticlesOnBlockFace(level, blockPos, (ParticleOptions)ModParticles.TERMITE_PARTICLE.get(), amount, direction, function, offset, faceDistance);
        }
    }

    public static void spawnParticlesOnBlockFace(Level level, BlockPos blockPos, ParticleOptions particle, IntProvider intProvider, Direction direction, BiFunction<Vec3, Vec3, Vec3> vecFunction, Vec3 offset, double faceDistance) {
        int amount = intProvider.m_214085_(level.f_46441_);
        if (amount > 0) {
            for (int i = 0; i < amount; ++i) {
                TermiteNestBlock.spawnParticleOnFace(level, blockPos, direction, particle, vecFunction, offset, faceDistance);
            }
        }
    }

    public static void spawnParticleOnFace(Level level, BlockPos blockPos, Direction direction, ParticleOptions particle, BiFunction<Vec3, Vec3, Vec3> vecFunction, Vec3 offset, double faceDistance) {
        Vec3 pos = Vec3.m_82512_((Vec3i)blockPos);
        int stepX = direction.m_122429_();
        int stepY = direction.m_122430_();
        int stepZ = direction.m_122431_();
        double x = pos.f_82479_ + (stepX == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)stepX * faceDistance);
        double y = pos.f_82480_ + (stepY == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)stepY * faceDistance);
        double z = pos.f_82481_ + (stepZ == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)stepZ * faceDistance);
        double x1 = pos.f_82479_ + (stepX == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)stepX * faceDistance);
        double y1 = pos.f_82480_ + (stepY == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)stepY * faceDistance);
        double z1 = pos.f_82481_ + (stepZ == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)stepZ * faceDistance);
        Vec3 vec = vecFunction.apply(new Vec3(x1, y1, z1), new Vec3(x, y, z));
        double dx = stepX == 0 ? vec.m_7096_() : 0.0;
        double dy = stepY == 0 ? vec.m_7098_() : 0.0;
        double dz = stepZ == 0 ? vec.m_7094_() : 0.0;
        level.m_7106_(particle, x + offset.f_82479_, y + offset.f_82480_, z + offset.f_82481_, dx, dy, dz);
    }
}

