/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.worldgen.custom;

import com.kaboomroads.lostfeatures.block.ModBlocks;
import com.kaboomroads.lostfeatures.block.custom.BadlandsCactusBlock;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BadlandsCactusFeature
extends Feature<NoneFeatureConfiguration> {
    public BadlandsCactusFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        BlockState belowState = level.m_8055_(blockPos.m_7495_());
        if (level.m_46859_(blockPos) && (belowState.m_60713_(Blocks.f_49992_) || belowState.m_60713_(Blocks.f_49993_))) {
            int amount = random.m_216339_(7, 10);
            BadlandsCactusBlock cactus = (BadlandsCactusBlock)ModBlocks.BADLANDS_CACTUS.get();
            level.m_7731_(blockPos, cactus.getStateForPlacement((BlockGetter)level, blockPos), 4);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(blockPos);
            for (int i = 0; i < amount; ++i) {
                LinkedList<BlockPos> newPositions = new LinkedList<BlockPos>();
                for (BlockPos blockPos2 : list) {
                    BlockPos grow;
                    if (random.m_188503_(2) != 0 || (grow = BadlandsCactusFeature.grow(cactus, level, blockPos2, level.m_213780_())) == null) continue;
                    newPositions.add(grow);
                }
                list.addAll(newPositions);
            }
            return true;
        }
        return false;
    }

    public static BlockPos grow(BadlandsCactusBlock block, WorldGenLevel level, BlockPos blockPos, RandomSource random) {
        ArrayList<BlockPos> possibilities = new ArrayList<BlockPos>(5);
        for (Direction dir : Direction.values()) {
            BlockPos rel = blockPos.m_121945_(dir);
            if (dir == Direction.DOWN || !block.canPlace(level, rel)) continue;
            possibilities.add(rel);
        }
        if (possibilities.isEmpty()) {
            return null;
        }
        BlockPos relative = (BlockPos)possibilities.get(random.m_188503_(possibilities.size()));
        if (level.m_8055_(relative).m_60795_()) {
            level.m_7731_(relative, block.getStateForPlacement((BlockGetter)level, relative), 3);
            BlockState newState = block.getStateForPlacement((BlockGetter)level, blockPos);
            level.m_7731_(blockPos, newState, 4);
            level.m_6018_().m_213960_(newState, relative, (Block)block, blockPos, false);
            return relative;
        }
        return null;
    }
}

