/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.kaboomroads.lostfeatures.damagesource.ModDamageSources;
import com.kaboomroads.lostfeatures.entity.ModEntityTypes;
import com.kaboomroads.lostfeatures.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceChunk
extends Entity {
    public int time;
    public float damage;
    public LivingEntity source;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(IceChunk.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public IceChunk(EntityType<? extends IceChunk> entityType, Level level) {
        super(entityType, level);
    }

    public IceChunk(Level level, double x, double y, double z, double dx, double dy, double dz, LivingEntity source) {
        this(ModEntityTypes.ICE_CHUNK.get(), level);
        this.m_6034_(x, y, z);
        this.m_20256_(new Vec3(dx, dy, dz));
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.source = source;
        this.setStartPos(this.m_20183_());
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos p_31960_) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        ++this.time;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_ && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
            this.destroy();
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    public void destroy() {
        this.m_146870_();
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 2.0, this.m_20186_() - 2.0, this.m_20189_() - 2.0, this.m_20185_() + 2.0, this.m_20186_() + 2.0, this.m_20189_() + 2.0), e -> (e instanceof Mob || e instanceof Player) && Utils.entityIsDamageable(e) && !(e instanceof Raider))) {
            entity.m_6469_(((ModDamageSources)this.m_269291_()).iceChunk(this, this.source), 6.0f);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50568_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, 0.75, 0.75, 0.75, 0.1);
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("Time", this.time);
        compoundTag.m_128350_("Damage", this.damage);
        if (this.source != null) {
            compoundTag.m_128405_("Source", this.source.m_19879_());
        }
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.time = compoundTag.m_128451_("Time");
        this.damage = compoundTag.m_128457_("Damage");
        this.source = (LivingEntity)this.m_9236_().m_6815_(compoundTag.m_128451_("Source"));
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6127_() {
        return true;
    }
}

