/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.google.common.collect.ImmutableList;
import com.kaboomroads.lostfeatures.entity.ai.brain.TuffGolemAi;
import com.kaboomroads.lostfeatures.utils.ClothColor;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TuffGolem
extends AbstractGolem {
    private static final EntityDataAccessor<Integer> CLOTH_COLOR = SynchedEntityData.m_135353_(TuffGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(1, 1, 1);
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState displayAnimationState = new AnimationState();
    public final AnimationState stopDisplayAnimationState = new AnimationState();
    public final AnimationState shakeAnimationState = new AnimationState();
    protected static final ImmutableList<SensorType<? extends Sensor<? super TuffGolem>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26810_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_217781_);
    protected int freezeTicks;
    protected int freezeDuration = this.f_19796_.m_216339_(100, 400);
    public Vec3 spawnPosition;
    public Direction spawnDirection;
    public boolean frozen = false;

    public TuffGolem(EntityType<? extends TuffGolem> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(this.m_21531_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLOTH_COLOR, (Object)0);
    }

    public ClothColor getClothColor() {
        return ClothColor.values()[(Integer)this.f_19804_.m_135370_(CLOTH_COLOR)];
    }

    public void setClothColor(ClothColor clothColor) {
        this.f_19804_.m_135381_(CLOTH_COLOR, (Object)clothColor.ordinal());
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.2);
    }

    public boolean m_21531_() {
        return !this.isOnPickupCooldown();
    }

    private boolean isOnPickupCooldown() {
        return this.m_6274_().m_21876_(MemoryModuleType.f_217781_, MemoryStatus.VALUE_PRESENT);
    }

    protected void m_7581_(@NotNull ItemEntity itemEntity) {
        if (itemEntity.m_32055_().m_41613_() > 1) {
            itemEntity.m_32055_().m_41764_(itemEntity.m_32055_().m_41613_() - 1);
            itemEntity = itemEntity.m_32066_();
            itemEntity.m_32055_().m_41764_(1);
        }
        super.m_7581_(itemEntity);
    }

    @NotNull
    public ItemStack m_255207_(@NotNull ItemStack item) {
        EquipmentSlot $$1 = EquipmentSlot.MAINHAND;
        ItemStack $$2 = this.m_6844_($$1);
        boolean $$3 = this.m_7808_(item, $$2);
        if ($$3 && this.m_7252_(item)) {
            double $$4 = this.m_21519_($$1);
            if (!$$2.m_41619_() && (double)Math.max(this.f_19796_.m_188501_() - 0.1f, 0.0f) < $$4) {
                this.m_19983_($$2);
            }
            if ($$1.m_254934_() && item.m_41613_() > 1) {
                ItemStack $$5 = item.m_255036_(1);
                this.m_21468_($$1, $$5);
                return $$5;
            }
            this.m_21468_($$1, item);
            return item;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    protected Vec3i m_213552_() {
        return ITEM_PICKUP_REACH;
    }

    public boolean m_7243_(@NotNull ItemStack itemStack) {
        return super.m_7243_(itemStack);
    }

    public boolean m_7252_(@NotNull ItemStack itemStack) {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
    }

    public void m_21053_(@NotNull ItemEntity itemEntity) {
        super.m_21053_(itemEntity);
        this.m_9236_().m_7605_((Entity)this, (byte)64);
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 $$1, @NotNull InteractionHand hand) {
        ItemStack handItem = player.m_21120_(hand);
        Item item = handItem.m_41720_();
        if (item instanceof DyeItem) {
            ClothColor color;
            DyeItem dyeItem = (DyeItem)item;
            switch (dyeItem.m_41089_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case RED: {
                    ClothColor clothColor = ClothColor.RED;
                    break;
                }
                case WHITE: {
                    ClothColor clothColor = ClothColor.WHITE;
                    break;
                }
                case ORANGE: {
                    ClothColor clothColor = ClothColor.ORANGE;
                    break;
                }
                case MAGENTA: {
                    ClothColor clothColor = ClothColor.MAGENTA;
                    break;
                }
                case LIGHT_BLUE: {
                    ClothColor clothColor = ClothColor.LIGHT_BLUE;
                    break;
                }
                case YELLOW: {
                    ClothColor clothColor = ClothColor.YELLOW;
                    break;
                }
                case LIME: {
                    ClothColor clothColor = ClothColor.LIME;
                    break;
                }
                case PINK: {
                    ClothColor clothColor = ClothColor.PINK;
                    break;
                }
                case GRAY: {
                    ClothColor clothColor = ClothColor.GRAY;
                    break;
                }
                case LIGHT_GRAY: {
                    ClothColor clothColor = ClothColor.LIGHT_GRAY;
                    break;
                }
                case CYAN: {
                    ClothColor clothColor = ClothColor.CYAN;
                    break;
                }
                case PURPLE: {
                    ClothColor clothColor = ClothColor.PURPLE;
                    break;
                }
                case BLUE: {
                    ClothColor clothColor = ClothColor.BLUE;
                    break;
                }
                case BROWN: {
                    ClothColor clothColor = ClothColor.BROWN;
                    break;
                }
                case GREEN: {
                    ClothColor clothColor = ClothColor.GREEN;
                    break;
                }
                case BLACK: {
                    ClothColor clothColor = color = ClothColor.BLACK;
                }
            }
            if (!this.m_9236_().f_46443_ && this.getClothColor() != color) {
                this.setClothColor(color);
                if (!player.m_150110_().f_35937_) {
                    handItem.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            if (!this.m_9236_().f_46443_) {
                this.m_6274_().m_21879_(MemoryModuleType.f_217781_, (Object)60);
                this.m_19983_(this.m_6844_(EquipmentSlot.MAINHAND));
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
                if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
                    this.m_19983_(itemstack);
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
                this.m_9236_().m_7605_((Entity)this, (byte)65);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_7111_(player, $$1, hand);
    }

    @NotNull
    protected Brain.Provider<TuffGolem> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return TuffGolemAi.makeBrain((Brain<TuffGolem>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<TuffGolem> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("tuffGolemBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        TuffGolemAi.updateActivity(this);
        super.m_8024_();
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("FreezeTicks", this.freezeTicks);
        compoundTag.m_128405_("FreezeDuration", this.freezeDuration);
        compoundTag.m_128379_("Frozen", this.frozen);
        compoundTag.m_128405_("Color", this.getClothColor().ordinal());
        if (this.spawnPosition != null) {
            compoundTag.m_128365_("SpawnPos", (Tag)this.m_20063_(new double[]{this.spawnPosition.f_82479_, this.spawnPosition.f_82480_, this.spawnPosition.f_82481_}));
        }
        if (this.spawnDirection != null) {
            compoundTag.m_128405_("SpawnDir", this.spawnDirection.ordinal());
        }
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        int ordinal;
        super.m_7378_(compoundTag);
        this.freezeTicks = compoundTag.m_128451_("FreezeTicks");
        this.frozen = compoundTag.m_128471_("Frozen");
        this.setClothColor(ClothColor.values()[compoundTag.m_128451_("Color")]);
        if (compoundTag.m_128441_("FreezeDuration")) {
            this.freezeDuration = compoundTag.m_128451_("FreezeDuration");
        }
        if (compoundTag.m_128441_("SpawnPos")) {
            ListTag pos = compoundTag.m_128437_("SpawnPos", 6);
            this.spawnPosition = new Vec3(Mth.m_14008_((double)pos.m_128772_(0), (double)-3.0000512E7, (double)3.0000512E7), Mth.m_14008_((double)pos.m_128772_(1), (double)-2.0E7, (double)2.0E7), Mth.m_14008_((double)pos.m_128772_(2), (double)-3.0000512E7, (double)3.0000512E7));
        }
        if (compoundTag.m_128441_("SpawnDir") && (ordinal = compoundTag.m_128451_("SpawnDir")) <= Direction.values().length - 1) {
            this.spawnDirection = Direction.values()[ordinal];
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 64: {
                this.displayAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 65: {
                this.displayAnimationState.m_216973_();
                this.stopDisplayAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 66: {
                this.shakeAnimationState.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public boolean m_6107_() {
        return this.frozen || super.m_6107_();
    }

    public void m_5997_(double $$0, double $$1, double $$2) {
        if (!this.m_6107_()) {
            super.m_5997_($$0, $$1, $$2);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.frozen) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.spawnPosition == null) {
                this.spawnPosition = this.m_20182_();
            }
            if (!this.m_21525_()) {
                ++this.freezeTicks;
            }
            if (this.freezeTicks >= this.freezeDuration) {
                if (this.frozen) {
                    this.frozen = false;
                    this.m_20334_(0.0, 0.0, 0.0);
                    this.m_9236_().m_7605_((Entity)this, (byte)66);
                    this.freezeTicks = 0;
                    this.freezeDuration = this.f_19796_.m_216339_(100, 400);
                } else {
                    Vec3 start = this.spawnPosition.m_82520_(0.0, 0.99, 0.0);
                    Vec3 end = new Vec3(this.spawnPosition.f_82479_, (double)this.m_9236_().m_141937_(), this.spawnPosition.f_82481_);
                    BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    BlockPos pos = hitResult.m_82425_();
                    Vec3 targetPos = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 1.0, 0.0);
                    this.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(Vec3.m_82539_((Vec3i)pos), 1.0f, 0));
                    if (this.f_21344_.m_26571_() && this.m_20238_(targetPos) <= 1.0) {
                        this.frozen = true;
                        this.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                        if (this.spawnDirection != null) {
                            float newYRot = this.spawnDirection.m_122435_();
                            this.m_19915_(newYRot, 0.0f);
                            this.f_20883_ = newYRot;
                            this.f_20885_ = newYRot;
                        }
                        this.m_20334_(0.0, 0.0, 0.0);
                        this.m_9236_().m_7605_((Entity)this, (byte)66);
                        this.freezeTicks = 0;
                        this.freezeDuration = this.f_19796_.m_216339_(100, 400);
                    }
                }
            }
        } else {
            this.walkAnimationState.m_246184_((this.m_20096_() || this.m_217005_()) && !this.m_21525_() && this.m_20184_().m_165925_() > 1.0E-6, this.f_19797_);
            if (!this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                this.displayAnimationState.m_216982_(this.f_19797_);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)65);
            }
        }
    }
}

