/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.mixin;

import com.kaboomroads.lostfeatures.entity.ModEntityTypes;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.world.entity.animal.Bee$BeePollinateGoal"})
public abstract class BeePollinateGoalMixin {
    @Final
    @Shadow(aliases={"field_20377"})
    Bee f_28062_;

    @Inject(method={"findNearbyFlower"}, at={@At(value="RETURN")})
    public void redirectFindNearbyFlower(CallbackInfoReturnable<Optional<BlockPos>> cir) {
        Optional<LivingEntity> nearest = this.getNearestEntity((LivingEntity)this.f_28062_);
        if (nearest.isPresent() && (((Optional)cir.getReturnValue()).isEmpty() || nearest.get().m_20183_().m_123331_((Vec3i)this.f_28062_.m_20183_()) < ((BlockPos)((Optional)cir.getReturnValue()).get()).m_123331_((Vec3i)this.f_28062_.m_20183_()))) {
            BlockPos blockPos = nearest.get().m_20183_();
            this.f_28062_.m_21573_().m_26519_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 3.0, (double)blockPos.m_123343_() + 0.5, 1.2);
        }
    }

    private Optional<LivingEntity> getNearestEntity(LivingEntity entity) {
        return this.getVisibleEntities(entity, (ServerLevel)entity.m_9236_()).flatMap($$1 -> $$1.m_186116_($$1x -> this.isMatchingEntity(entity, (LivingEntity)$$1x)));
    }

    private boolean isMatchingEntity(@NotNull LivingEntity entity, @NotNull LivingEntity otherEntity) {
        return this.isClose(entity, otherEntity) && otherEntity.m_6095_() == ModEntityTypes.MOOBLOOM.get();
    }

    private boolean isClose(LivingEntity entity, LivingEntity otherEntity) {
        double followRange = entity.m_21133_(Attributes.f_22277_);
        return otherEntity.m_20280_((Entity)entity) <= followRange * followRange;
    }

    private Optional<NearestVisibleLivingEntities> getVisibleEntities(LivingEntity entity, ServerLevel level) {
        AABB aabb = entity.m_20191_().m_82377_(entity.m_21133_(Attributes.f_22277_), entity.m_21133_(Attributes.f_22277_), entity.m_21133_(Attributes.f_22277_));
        List list = level.m_6443_(LivingEntity.class, aabb, p_26717_ -> p_26717_ != entity && p_26717_.m_6084_());
        list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).m_20280_(arg_0)));
        return Optional.of(new NearestVisibleLivingEntities(entity, list));
    }
}

