/*
 * Decompiled with CFR 0.152.
 */
package net.kaupenjoe.magnificentstaffs.entity.custom;

import net.kaupenjoe.magnificentstaffs.entity.ModEntities;
import net.kaupenjoe.magnificentstaffs.particles.ModParticles;
import net.kaupenjoe.magnificentstaffs.sound.ModSound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BasicMagicProjectileEntity
extends Projectile {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(BasicMagicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HIT = SynchedEntityData.m_135353_(BasicMagicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COUNT = SynchedEntityData.m_135353_(BasicMagicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BasicMagicProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public BasicMagicProjectileEntity(Level level, Player player) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntities.MAGIC_PROJECTILE.get()), level);
        this.m_5602_((Entity)player);
        BlockPos blockpos = player.m_20183_();
        double d0 = (double)blockpos.m_123341_() + 0.5;
        double d1 = (double)blockpos.m_123342_() + 1.75;
        double d2 = (double)blockpos.m_123343_() + 0.5;
        this.m_7678_(d0, d1, d2, this.m_146908_(), this.m_146909_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(COUNT, (Object)0);
        this.f_19804_.m_135372_(HIT, (Object)false);
    }

    public void setType(MagicProjectileType type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.ordinal());
    }

    public int getProjectileType() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(HIT)).booleanValue()) {
            this.f_19804_.m_135381_(COUNT, (Object)((Integer)this.f_19804_.m_135370_(COUNT) + 1));
            if ((Integer)this.f_19804_.m_135370_(COUNT) >= 5) {
                this.destroy();
            }
        }
        if (this.f_19797_ >= 300) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vec3 vec3 = this.m_20184_();
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        double d5 = vec3.f_82479_;
        double d6 = vec3.f_82480_;
        double d7 = vec3.f_82481_;
        for (int i = 1; i < 5; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)this.getParticleType(), d0 - d5 * 2.0, d1 - d6 * 2.0, d2 - d7 * 2.0, -d5, -d6 - 0.1, -d7);
        }
        if (this.f_19853_.m_45556_(this.m_20191_()).noneMatch(BlockBehaviour.BlockStateBase::m_60795_)) {
            this.m_146870_();
        } else if (this.m_20072_()) {
            this.m_146870_();
        } else {
            this.m_20256_(vec3.m_82490_((double)0.99f));
            this.m_6034_(d0, d1, d2);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public SimpleParticleType getParticleType() {
        return switch ((Integer)this.f_19804_.m_135370_(TYPE)) {
            default -> (SimpleParticleType)ModParticles.SAPPHIRE_MAGIC_PARTICLES.get();
            case 1 -> (SimpleParticleType)ModParticles.DIAMOND_MAGIC_PARTICLES.get();
            case 2 -> (SimpleParticleType)ModParticles.RUBY_MAGIC_PARTICLES.get();
            case 3 -> (SimpleParticleType)ModParticles.AMETHYST_MAGIC_PARTICLES.get();
            case 4 -> (SimpleParticleType)ModParticles.EMERALD_MAGIC_PARTICLES.get();
            case 5 -> (SimpleParticleType)ModParticles.RADIATION_MAGIC_PARTICLES.get();
            case 6 -> (SimpleParticleType)ModParticles.VENOM_MAGIC_PARTICLES.get();
        };
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        Entity hitEntity = hitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (hitEntity == owner && this.f_19853_.m_5776_()) {
            return;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSound.MAGIC_IMPACT_1.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
        LivingEntity livingentity = owner instanceof LivingEntity ? (LivingEntity)owner : null;
        float damage = switch ((Integer)this.f_19804_.m_135370_(TYPE)) {
            default -> 3.0f;
            case 1 -> 9.0f;
            case 2 -> 5.0f;
            case 3 -> 7.0f;
            case 4 -> 4.0f;
            case 5, 6 -> 2.0f;
        };
        boolean hurt = hitEntity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingentity), damage);
        if (hurt) {
            LivingEntity livingHitEntity;
            if ((Integer)this.f_19804_.m_135370_(TYPE) == 5 && hitEntity instanceof LivingEntity) {
                livingHitEntity = (LivingEntity)hitEntity;
                livingHitEntity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 60), owner);
            }
            if ((Integer)this.f_19804_.m_135370_(TYPE) == 6 && hitEntity instanceof LivingEntity) {
                livingHitEntity = (LivingEntity)hitEntity;
                livingHitEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 100, 1), owner);
            }
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        for (int x = 0; x < 18; ++x) {
            for (int y = 0; y < 18; ++y) {
                this.f_19853_.m_7106_((ParticleOptions)this.getParticleType(), this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.cos(x * 20) * 0.15, Math.cos(y * 20) * 0.15, Math.sin(x * 20) * 0.15);
            }
        }
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity hit = entityHitResult.m_82443_();
            Entity owner = this.m_19749_();
            if (owner != hit) {
                this.f_19804_.m_135381_(HIT, (Object)true);
            }
        } else {
            this.f_19804_.m_135381_(HIT, (Object)true);
        }
    }

    private void destroy() {
        this.m_146870_();
        this.f_19853_.m_214171_(GameEvent.f_223706_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
    }

    public static enum MagicProjectileType {
        SAPPHIRE,
        DIAMOND,
        RUBY,
        AMETHYST,
        EMERALD,
        RADIATION,
        VENOM;

    }
}

