/*
 * Decompiled with CFR 0.152.
 */
package net.kaupenjoe.magnificentstaffs.entity.custom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kaupenjoe.magnificentstaffs.entity.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SeekingMagicProjectileEntity
extends Projectile {
    private Entity target;
    private UUID targetId;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;

    public SeekingMagicProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public SeekingMagicProjectileEntity(Level level, Player player, Entity target) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntities.SEEKING_MAGIC_PROJECTILE.get()), level);
        this.m_5602_((Entity)player);
        BlockPos blockpos = player.m_20183_();
        this.target = target;
        double d0 = (double)blockpos.m_123341_() + 0.5;
        double d1 = (double)blockpos.m_123342_() + 1.75;
        double d2 = (double)blockpos.m_123343_() + 0.5;
        this.m_7678_(d0, d1, d2, this.m_146908_(), this.m_146909_());
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(Direction.Axis.Y);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            HitResult hitresult;
            if (this.target == null && this.targetId != null) {
                this.target = ((ServerLevel)this.f_19853_).m_8791_(this.targetId);
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.target == null || !this.target.m_6084_() || this.target instanceof Player && this.target.m_5833_()) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = Mth.m_14008_((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = Mth.m_14008_((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = Mth.m_14008_((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                Vec3 vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_((this.targetDeltaX - vec3.f_82479_) * 0.2, (this.targetDeltaY - vec3.f_82480_) * 0.2, (this.targetDeltaZ - vec3.f_82481_) * 0.2));
            }
            if ((hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
        }
        this.m_20101_();
        Vec3 vec31 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec31.f_82479_, this.m_20186_() + vec31.f_82480_, this.m_20189_() + vec31.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_ + 0.15, this.m_20189_() - vec31.f_82481_, 0.0, 0.0, 0.0);
        } else if (this.target != null && !this.target.m_213877_()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.m_122434_());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos blockpos = this.m_20183_();
                Direction.Axis direction$axis = this.currentMoveDirection.m_122434_();
                if (this.f_19853_.m_46575_(blockpos.m_121945_(this.currentMoveDirection), (Entity)this)) {
                    this.selectNextMoveDirection(direction$axis);
                } else {
                    BlockPos blockpos1 = this.target.m_20183_();
                    if (direction$axis == Direction.Axis.X && blockpos.m_123341_() == blockpos1.m_123341_() || direction$axis == Direction.Axis.Z && blockpos.m_123343_() == blockpos1.m_123343_() || direction$axis == Direction.Axis.Y && blockpos.m_123342_() == blockpos1.m_123342_()) {
                        this.selectNextMoveDirection(direction$axis);
                    }
                }
            }
        }
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis p_37349_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.target == null) {
            blockpos = this.m_20183_().m_7495_();
        } else {
            d0 = (double)this.target.m_20206_() * 0.5;
            blockpos = BlockPos.m_274561_((double)this.target.m_20185_(), (double)(this.target.m_20186_() + d0), (double)this.target.m_20189_());
        }
        double d1 = (double)blockpos.m_123341_() + 0.5;
        double d2 = (double)blockpos.m_123342_() + d0;
        double d3 = (double)blockpos.m_123343_() + 0.5;
        Direction direction = null;
        if (!blockpos.m_203195_((Position)this.m_20182_(), 2.0)) {
            BlockPos blockpos1 = this.m_20183_();
            ArrayList list = Lists.newArrayList();
            if (p_37349_ != Direction.Axis.X) {
                if (blockpos1.m_123341_() < blockpos.m_123341_() && this.f_19853_.m_46859_(blockpos1.m_122029_())) {
                    list.add(Direction.EAST);
                } else if (blockpos1.m_123341_() > blockpos.m_123341_() && this.f_19853_.m_46859_(blockpos1.m_122024_())) {
                    list.add(Direction.WEST);
                }
            }
            if (p_37349_ != Direction.Axis.Y) {
                if (blockpos1.m_123342_() < blockpos.m_123342_() && this.f_19853_.m_46859_(blockpos1.m_7494_())) {
                    list.add(Direction.UP);
                } else if (blockpos1.m_123342_() > blockpos.m_123342_() && this.f_19853_.m_46859_(blockpos1.m_7495_())) {
                    list.add(Direction.DOWN);
                }
            }
            if (p_37349_ != Direction.Axis.Z) {
                if (blockpos1.m_123343_() < blockpos.m_123343_() && this.f_19853_.m_46859_(blockpos1.m_122019_())) {
                    list.add(Direction.SOUTH);
                } else if (blockpos1.m_123343_() > blockpos.m_123343_() && this.f_19853_.m_46859_(blockpos1.m_122012_())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.m_235672_((RandomSource)this.f_19796_);
            if (list.isEmpty()) {
                for (int i = 5; !this.f_19853_.m_46859_(blockpos1.m_121945_(direction)) && i > 0; --i) {
                    direction = Direction.m_235672_((RandomSource)this.f_19796_);
                }
            } else {
                direction = (Direction)list.get(this.f_19796_.m_188503_(list.size()));
            }
            d1 = this.m_20185_() + (double)direction.m_122429_();
            d2 = this.m_20186_() + (double)direction.m_122430_();
            d3 = this.m_20189_() + (double)direction.m_122431_();
        }
        this.setMoveDirection(direction);
        double d6 = d1 - this.m_20185_();
        double d7 = d2 - this.m_20186_();
        double d4 = d3 - this.m_20189_();
        double d5 = Math.sqrt(d6 * d6 + d7 * d7 + d4 * d4);
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.f_19812_ = true;
        this.flightSteps = 10 + this.f_19796_.m_188503_(5) * 10;
    }

    @Nullable
    private Direction getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable Direction p_37351_) {
        this.currentMoveDirection = p_37351_;
    }

    protected boolean m_5603_(Entity p_37341_) {
        return super.m_5603_(p_37341_) && !p_37341_.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double p_37336_) {
        return p_37336_ < 16384.0;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected void m_5790_(EntityHitResult p_37345_) {
        super.m_5790_(p_37345_);
        Entity entity = p_37345_.m_82443_();
        Entity entity1 = this.m_19749_();
        LivingEntity livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
        boolean flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingentity), 6.0f);
    }

    protected void m_8060_(BlockHitResult p_37343_) {
        super.m_8060_(p_37343_);
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        this.m_5496_(SoundEvents.f_12410_, 1.0f, 1.0f);
    }

    private void destroy() {
        this.m_146870_();
        this.f_19853_.m_214171_(GameEvent.f_223706_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
    }

    protected void m_6532_(HitResult p_37347_) {
        super.m_6532_(p_37347_);
        this.destroy();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

