/*
 * Decompiled with CFR 0.152.
 */
package net.kaupenjoe.magnificentstaffs.item.custom;

import java.util.ArrayList;
import net.kaupenjoe.magnificentstaffs.entity.custom.ClingerWallEntity;
import net.kaupenjoe.magnificentstaffs.sound.ModSound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class ClingerStaff
extends Item {
    public static final int HURT_MULTIPLIER = 8;
    private float maxDistance = 32.0f;

    public ClingerStaff(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41783_() != null && !itemstack.m_41783_().m_128469_("first-location").m_128456_()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSound.MAGIC_MISSLE.get(), SoundSource.NEUTRAL, 1.5f, 1.0f);
        BlockPos blockPlayerIsLookingAt = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)this.maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
        if (level.m_8055_(blockPlayerIsLookingAt).m_60713_(Blocks.f_50016_)) {
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (itemstack.m_41783_() == null) {
            itemstack.m_41751_(new CompoundTag());
        }
        itemstack.m_41783_().m_128365_("first-location", (Tag)NbtUtils.m_129224_((BlockPos)blockPlayerIsLookingAt));
        player.m_6672_(hand);
        if (!level.m_5776_()) {
            // empty if block
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public int m_8105_(ItemStack itemStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSound.MAGIC_MISSLE.get(), SoundSource.NEUTRAL, 1.5f, 1.0f);
            int blocksSpawned = 0;
            BlockPos blockPlayerIsLookingAt = player.f_19853_.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_((double)this.maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
            if (player.f_19853_.m_8055_(blockPlayerIsLookingAt).m_60713_(Blocks.f_50016_)) {
                return;
            }
            if (!player.f_19853_.f_46443_) {
                ArrayList<BlockPos> baseBlocks = new ArrayList<BlockPos>();
                BlockPos firstPos = NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_("first-location"));
                Vec3 direction = new Vec3((double)(blockPlayerIsLookingAt.m_123341_() - firstPos.m_123341_()), (double)(blockPlayerIsLookingAt.m_123342_() - firstPos.m_123342_()), (double)(blockPlayerIsLookingAt.m_123343_() - firstPos.m_123343_()));
                direction = direction.m_82541_();
                for (int i = 0; i < 45; ++i) {
                    BlockPos blockPosToSave = new BlockPos((Vec3i)firstPos.m_7918_((int)Math.round(direction.f_82479_ * (double)i), (int)Math.round(direction.f_82480_ * (double)i), (int)Math.round(direction.f_82481_ * (double)i)));
                    if (player.f_19853_.m_8055_(blockPlayerIsLookingAt).m_60713_(Blocks.f_50016_)) continue;
                    if (blockPosToSave.equals((Object)blockPlayerIsLookingAt)) {
                        blockPosToSave.m_175288_(level.m_5452_(Heightmap.Types.WORLD_SURFACE, firstPos).m_123342_());
                        baseBlocks.add(blockPosToSave);
                        break;
                    }
                    blockPosToSave.m_175288_(level.m_5452_(Heightmap.Types.WORLD_SURFACE, firstPos).m_123342_());
                    baseBlocks.add(blockPosToSave);
                    blocksSpawned = i;
                }
                for (BlockPos position : baseBlocks) {
                    level.m_7967_((Entity)new ClingerWallEntity(level, position));
                }
            }
            stack.m_41783_().m_128365_("first-location", (Tag)new CompoundTag());
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                stack.m_41622_(blocksSpawned * 8, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int count, boolean p_41408_) {
        super.m_6883_(stack, level, entity, count, p_41408_);
        if (count % 20 == 0 && stack.m_41773_() >= 1) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }
}

