/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.util;

import java.util.function.DoubleUnaryOperator;

public class CompactConversionsUtil {
    public static double[] hsl2rgb(double h, double s, double l) {
        double a = s * Math.min(l, 1.0 - l);
        DoubleUnaryOperator f = n -> {
            double k = (n + h / 30.0) % 12.0;
            return l - a * Math.max(Math.min(Math.min(k - 3.0, 9.0 - k), 1.0), -1.0);
        };
        return new double[]{f.applyAsDouble(0.0), f.applyAsDouble(8.0), f.applyAsDouble(4.0)};
    }

    public static double[] rgb2hsl(double r, double g, double b) {
        double v = Math.max(Math.max(r, g), b);
        double c = v - Math.min(Math.min(r, g), b);
        double f = 1.0 - Math.abs(v + v - c - 1.0);
        double h = c != 0.0 ? (v == r ? (g - b) / c : (v == g ? 2.0 + (b - r) / c : 4.0 + (r - g) / c)) : 0.0;
        return new double[]{60.0 * (h < 0.0 ? h + 6.0 : h), f != 0.0 ? c / f : 0.0, (v + v - c) / 2.0};
    }

    public static double[] rgb2hsv(double r, double g, double b) {
        double v = Math.max(Math.max(r, g), b);
        double c = v - Math.min(Math.min(r, g), b);
        double h = c != 0.0 ? (v == r ? (g - b) / c : (v == g ? 2.0 + (b - r) / c : 4.0 + (r - g) / c)) : 0.0;
        return new double[]{60.0 * (h < 0.0 ? h + 6.0 : h), v != 0.0 ? c / v : 0.0, v};
    }

    public static double[] hsv2rgb(double h, double s, double v) {
        DoubleUnaryOperator f = n -> {
            double k = (n + h / 60.0) % 6.0;
            return v - v * s * Math.max(Math.min(Math.min(k, 4.0 - k), 1.0), 0.0);
        };
        return new double[]{f.applyAsDouble(5.0), f.applyAsDouble(3.0), f.applyAsDouble(1.0)};
    }
}

