/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.gui.screens.PixelConfigScreen;
import fuzs.mindfuldarkness.client.handler.ColorChangedAssetsManager;
import fuzs.mindfuldarkness.config.ClientConfig;
import fuzs.mindfuldarkness.mixin.client.accessor.AbstractContainerMenuAccessor;
import fuzs.puzzleslib.client.gui.screens.CommonScreens;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class DaytimeSwitcherHandler {
    public static final ResourceLocation TEXTURE_LOCATION = MindfulDarkness.id("textures/gui/daytime_switcher.png");
    private static AbstractWidget[] buttons;

    public static void onClientTick$End(Minecraft minecraft) {
        AbstractContainerScreen screen;
        Screen screen2;
        if (buttons != null && (screen2 = minecraft.f_91080_) instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2) instanceof RecipeUpdateListener) {
            int leftPos = CommonScreens.INSTANCE.getLeftPos(screen);
            int imageWidth = CommonScreens.INSTANCE.getImageWidth(screen);
            DaytimeSwitcherHandler.buttons[0].f_93620_ = leftPos + imageWidth - 3 - 21;
            DaytimeSwitcherHandler.buttons[1].f_93620_ = leftPos + imageWidth - 3 - 40;
            DaytimeSwitcherHandler.buttons[2].f_93620_ = leftPos + imageWidth - 3 - 68;
            DaytimeSwitcherHandler.buttons[3].f_93620_ = leftPos + imageWidth - 3 - 95;
        }
    }

    public static Optional<Screen> onScreenOpen(@Nullable Screen oldScreen, @Nullable Screen newScreen) {
        if (newScreen == null) {
            buttons = null;
        }
        if (newScreen instanceof AbstractContainerScreen) {
            MenuType<?> type;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)newScreen;
            if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugContainerTypes && (type = ((AbstractContainerMenuAccessor)containerScreen.m_6262_()).mindfuldarkness$getMenuType()) != null) {
                MutableComponent component = Component.m_237113_((String)Registry.f_122863_.m_7981_(type).toString());
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"debug.menu.opening", (Object[])new Object[]{ComponentUtils.m_130748_((Component)component)}));
            }
        }
        return Optional.empty();
    }

    public static void onContainerScreen$Render$Background(AbstractContainerScreen<?> screen, PoseStack poseStack, int mouseX, int mouseY) {
        if (DaytimeSwitcherHandler.supportsDaytimeSwitcher(screen)) {
            DaytimeSwitcherHandler.drawThemeBg(poseStack, CommonScreens.INSTANCE.getLeftPos(screen), CommonScreens.INSTANCE.getTopPos(screen), CommonScreens.INSTANCE.getImageWidth(screen));
        }
    }

    public static void drawThemeBg(PoseStack poseStack, int leftPos, int topPos, int imageWidth) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(leftPos + imageWidth - 3 - 101), (int)(topPos - 24), (float)0.0f, (float)226.0f, (int)101, (int)24, (int)256, (int)256);
    }

    private static boolean supportsDaytimeSwitcher(AbstractContainerScreen<?> containerScreen) {
        if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).hideInGameSwitcher) {
            return false;
        }
        if (containerScreen.f_96544_ >= CommonScreens.INSTANCE.getImageHeight(containerScreen) + 48) {
            if (containerScreen instanceof CreativeModeInventoryScreen) {
                return false;
            }
            MenuType<?> type = ((AbstractContainerMenuAccessor)containerScreen.m_6262_()).mindfuldarkness$getMenuType();
            return type == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).menuBlacklist.contains(type);
        }
        return false;
    }

    public static void onScreenInit$Post(Screen screen, Minecraft minecraft, int width, int height, UnaryOperator<AbstractWidget> addWidget) {
        AbstractContainerScreen containerScreen;
        if (screen instanceof AbstractContainerScreen && DaytimeSwitcherHandler.supportsDaytimeSwitcher(containerScreen = (AbstractContainerScreen)screen)) {
            buttons = DaytimeSwitcherHandler.makeButtons(minecraft, screen, CommonScreens.INSTANCE.getLeftPos(containerScreen), CommonScreens.INSTANCE.getTopPos(containerScreen), CommonScreens.INSTANCE.getImageWidth(containerScreen), addWidget);
        }
    }

    public static AbstractWidget[] makeButtons(Minecraft minecraft, Screen screen, int leftPos, int topPos, int imageWidth, UnaryOperator<AbstractWidget> addWidget) {
        AbstractWidget[] abstractWidgets;
        abstractWidgets = new AbstractWidget[]{(AbstractWidget)addWidget.apply((AbstractWidget)new ImageButton(leftPos + imageWidth - 3 - 21, topPos - 18, 15, 15, 224, 0, TEXTURE_LOCATION, button -> screen.m_7379_())), (AbstractWidget)addWidget.apply((AbstractWidget)new ImageButton(leftPos + imageWidth - 3 - 40, topPos - 18, 15, 15, 239, 0, TEXTURE_LOCATION, button -> {
            if (screen instanceof PixelConfigScreen) {
                PixelConfigScreen pixelConfigScreen = (PixelConfigScreen)screen;
                pixelConfigScreen.closeToLastScreen();
            } else {
                minecraft.m_91152_((Screen)new PixelConfigScreen(screen));
            }
        })), (AbstractWidget)addWidget.apply((AbstractWidget)new ImageButton(leftPos + imageWidth - 3 - 68, topPos - 20, 24, 19, 200, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true))), (AbstractWidget)addWidget.apply((AbstractWidget)new ImageButton(leftPos + imageWidth - 3 - 95, topPos - 20, 24, 19, 176, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true)))};
        DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], false);
        return abstractWidgets;
    }

    private static void toggleThemeButtons(AbstractWidget lightThemeWidget, AbstractWidget darkThemeWidget, boolean toggleSetting) {
        boolean darkTheme;
        if (toggleSetting) {
            DaytimeSwitcherHandler.activateDaytimeSwitch();
        }
        lightThemeWidget.f_93623_ = darkTheme = ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue();
        darkThemeWidget.f_93623_ = !darkTheme;
    }

    public static void activateDaytimeSwitch() {
        boolean darkTheme = (Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get();
        darkTheme = !darkTheme;
        ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.set((Object)darkTheme);
        ColorChangedAssetsManager.INSTANCE.recordedReset();
    }
}

