/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public final class ScreenElementPositioner {
    private ScreenElementPositioner() {
    }

    public static boolean tryPositionElement(AbstractWidget element, List<? extends GuiEventListener> widgets, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, false, translationKeys);
    }

    public static boolean tryPositionElement(AbstractWidget element, List<? extends GuiEventListener> widgets, boolean tryPositionRightFirst, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, tryPositionRightFirst, 4, translationKeys);
    }

    public static boolean tryPositionElement(AbstractWidget element, List<? extends GuiEventListener> widgets, boolean tryPositionRightFirst, int horizontalOffset, String ... translationKeys) {
        int originalX = element.m_252754_();
        int originalY = element.m_252907_();
        for (String translationKey : translationKeys) {
            AbstractWidget otherElement = ScreenElementPositioner.findElement(widgets, translationKey);
            if (otherElement == null) continue;
            ScreenElementPositioner.moveElementToOther(element, otherElement, tryPositionRightFirst, horizontalOffset);
            if (ScreenElementPositioner.noOverlapWithExisting(widgets, element)) {
                return true;
            }
            ScreenElementPositioner.moveElementToOther(element, otherElement, !tryPositionRightFirst, horizontalOffset);
            if (!ScreenElementPositioner.noOverlapWithExisting(widgets, element)) continue;
            return true;
        }
        element.m_252846_(originalX, originalY);
        return false;
    }

    private static void moveElementToOther(AbstractWidget element, AbstractWidget otherElement, boolean tryPositionRightFirst, int horizontalOffset) {
        if (tryPositionRightFirst) {
            ScreenElementPositioner.moveToRight(element, otherElement, horizontalOffset);
        } else {
            ScreenElementPositioner.moveToLeft(element, otherElement, horizontalOffset);
        }
    }

    private static void moveToLeft(AbstractWidget element, AbstractWidget otherElement, int horizontalOffset) {
        element.m_252846_(otherElement.m_252754_() - element.m_5711_() - horizontalOffset, otherElement.m_252907_());
    }

    private static void moveToRight(AbstractWidget element, AbstractWidget otherElement, int horizontalOffset) {
        element.m_252846_(otherElement.m_252754_() + otherElement.m_5711_() + horizontalOffset, otherElement.m_252907_());
    }

    private static boolean noOverlapWithExisting(List<? extends GuiEventListener> widgets, AbstractWidget element) {
        for (GuiEventListener guiEventListener : widgets) {
            AbstractWidget otherElement;
            if (!(guiEventListener instanceof AbstractWidget) || !ScreenElementPositioner.intersection(element, otherElement = (AbstractWidget)guiEventListener)) continue;
            return false;
        }
        return true;
    }

    private static boolean intersection(AbstractWidget element, AbstractWidget otherElement) {
        int i = Math.max(element.m_252754_(), otherElement.m_252754_());
        int j = Math.max(element.m_252907_(), otherElement.m_252907_());
        int k = Math.min(element.m_252754_() + element.m_5711_(), otherElement.m_252754_() + otherElement.m_5711_());
        int l = Math.min(element.m_252907_() + element.m_93694_(), otherElement.m_252907_() + otherElement.m_93694_());
        return i < k && j < l;
    }

    @Nullable
    private static AbstractWidget findElement(List<? extends GuiEventListener> widgets, String translationKey) {
        for (GuiEventListener guiEventListener : widgets) {
            AbstractWidget widget;
            if (!(guiEventListener instanceof AbstractWidget) || !ScreenElementPositioner.matchesTranslationKey(widget = (AbstractWidget)guiEventListener, translationKey)) continue;
            return widget;
        }
        return null;
    }

    private static boolean matchesTranslationKey(AbstractWidget widget, String translationKey) {
        TranslatableContents contents;
        ComponentContents message = widget.m_6035_().m_214077_();
        return message instanceof TranslatableContents && (contents = (TranslatableContents)message).m_237508_().equals(translationKey);
    }
}

