/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.config;

import com.google.common.collect.Lists;
import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.handler.ColorChangedAssetsManager;
import fuzs.mindfuldarkness.client.packs.resources.ColorChangingResourceHandler;
import fuzs.mindfuldarkness.client.util.PixelDarkener;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig
implements ConfigCore {
    public ForgeConfigSpec.BooleanValue darkTheme;
    public ForgeConfigSpec.DoubleValue textureDarkness;
    public ForgeConfigSpec.DoubleValue fontBrightness;
    public ForgeConfigSpec.EnumValue<PixelDarkener> darkeningAlgorithm;
    @Config(name="paths", description={"Specifies gui paths and resources to darken.", "End a path using '*' as a wildcard char to include every file (no nested directories) from that directory.", "Begin with a namespace or skip namespace to apply to all namespaces.", "Begin with '!' to exclude matches, list those exclusions after entries that would otherwise include them."})
    List<String> pathsRaw = Lists.newArrayList((Object[])new String[]{"textures/gui/*", "!minecraft:textures/gui/icons.png", "!minecraft:textures/gui/options_background.png", "textures/gui/container/*", "minecraft:textures/gui/container/creative_inventory/*", "trinkets:textures/gui/slots/*", "craftingtweaks:gui.png", "dankstorage:textures/container/gui/*", "ae2:textures/guis/*"});
    @Config(description={"Do not add the dark mode toggle buttons to the top of every menu."})
    public boolean hideInGameSwitcher = false;
    @Config(name="menu_blacklist", description={"Exclude certain menus from showing the dark mode switcher. Useful when the box intersects other screen elements."})
    List<String> menuBlacklistRaw = Lists.newArrayList();
    @Config(description={"Print menu type to game chat whenever a new menu screen is opened. Intended for finding menu types to be added to \"menu_blacklist\"."})
    public boolean debugContainerTypes = false;
    @Config(description={"Screens to add a dark mode toggle button to, so that toggling is possible outside of inventory menus."})
    public DaytimeButtonScreens darkModeToggleScreens = DaytimeButtonScreens.BOTH;
    public List<String> paths;
    public ConfigDataSet<MenuType<?>> menuBlacklist;

    public void addToBuilder(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        this.darkTheme = builder.comment("Use a dark theme for the configuration screens.").define("dark_theme", false);
        this.textureDarkness = builder.comment("Percentage of original interface brightness to apply.").defineInRange("texture_darkness", 0.5, 0.0, 1.0);
        this.fontBrightness = builder.comment("The minimum brightness value of font while dark mode is enabled.").defineInRange("font_brightness", 0.75, 0.0, 1.0);
        this.darkeningAlgorithm = builder.comment("Algorithm selector for darkening interface pixels.").defineEnum("darkening_algorithm", (Enum)PixelDarkener.GRAYSCALE_AND_HSP);
    }

    public void afterConfigReload() {
        this.paths = this.pathsRaw.stream().filter(s -> {
            if (!s.matches("^!?([a-z0-9_.-]+:)?([a-z0-9/_.-]+|(([a-z0-9/_.-]*/|)\\*(\\.\\w+)?))$")) {
                MindfulDarkness.LOGGER.warn("'{}' is an invalid path and will be ignored", s);
                return false;
            }
            return true;
        }).toList();
        this.menuBlacklist = ConfigDataSet.from((ResourceKey)Registries.f_256798_, this.menuBlacklistRaw);
        ColorChangedAssetsManager.INSTANCE.recordedReset();
        ColorChangingResourceHandler.INSTANCE.clear();
    }

    public static enum DaytimeButtonScreens {
        NONE(screen -> false, new String[0]),
        TITLE_SCREEN(screen -> screen instanceof TitleScreen, "modmenu.title", "fml.menu.mods", "menu.online", "menu.multiplayer", "menu.singleplayer"),
        PAUSE_SCREEN(screen -> screen instanceof PauseScreen, "modmenu.title", "fml.menu.mods", "menu.reportBugs", "menu.shareToLan", "menu.playerReporting", "menu.options", "gui.stats"),
        BOTH(screen -> screen instanceof TitleScreen || screen instanceof PauseScreen, "modmenu.title", "fml.menu.mods", "menu.online", "menu.multiplayer", "menu.singleplayer", "menu.reportBugs", "menu.shareToLan", "menu.playerReporting", "menu.options", "gui.stats");

        public final Predicate<Screen> filter;
        public final String[] buttonKeys;

        private DaytimeButtonScreens(Predicate<Screen> filter, String ... translationKeys) {
            this.filter = filter;
            this.buttonKeys = translationKeys;
        }
    }
}

