/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.packs.resources;

import com.google.common.collect.Lists;
import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.handler.ColorChangedAssetsManager;
import fuzs.mindfuldarkness.client.packs.resources.ForwardingResource;
import fuzs.mindfuldarkness.client.util.PixelDarkener;
import fuzs.mindfuldarkness.client.util.RGBBrightnessUtil;
import fuzs.mindfuldarkness.config.ClientConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7367;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ColorChangingResourceHandler {
    public static final String VALID_RESOURCE_LOCATION_NAMESPACE = "[a-z0-9_.-]";
    public static final String VALID_RESOURCE_LOCATION_PATH = "[a-z0-9/._-]";
    public static final String VALID_MINDFUL_DARKNESS_PATH = "^!?([a-z0-9_.-]+:)?([a-z0-9/_.-]+|(([a-z0-9/_.-]*/|)\\*(\\.\\w+)?))$";
    public static final ColorChangingResourceHandler INSTANCE = new ColorChangingResourceHandler();
    @Nullable
    private List<String> normalizedDomains;
    @Nullable
    private List<Function<String, Boolean>> validPaths;

    private ColorChangingResourceHandler() {
    }

    public Optional<class_3298> getResource(class_2960 location, Optional<class_3298> resource) {
        if (resource.isPresent() && this.matchesPath(location)) {
            ColorChangedAssetsManager.INSTANCE.add(location);
            if (((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue()) {
                double textureDarkness = (Double)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).textureDarkness.get();
                PixelDarkener algorithm = (PixelDarkener)((Object)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkeningAlgorithm.get());
                ByteArrayInputStream inputStream = ColorChangingResourceHandler.adjustImage(resource.get(), textureDarkness, algorithm);
                ForwardingResource newResource = new ForwardingResource(resource.get(), (class_7367<InputStream>)((class_7367)() -> inputStream));
                return Optional.of(newResource);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ByteArrayInputStream adjustImage(class_3298 resource, double textureDarkness, PixelDarkener algorithm) {
        try (InputStream open = resource.method_14482();){
            ByteArrayInputStream byteArrayInputStream;
            block16: {
                class_1011 image = class_1011.method_4309((InputStream)open);
                try {
                    for (int x = 0; x < image.method_4307(); ++x) {
                        for (int y = 0; y < image.method_4323(); ++y) {
                            int pixel = image.method_4315(x, y);
                            int alpha = RGBBrightnessUtil.getA(pixel);
                            if (alpha == 0) continue;
                            image.method_4305(x, y, algorithm.processPixel(pixel, textureDarkness) | alpha << 24);
                        }
                    }
                    byteArrayInputStream = new ByteArrayInputStream(image.method_24036());
                    if (image == null) break block16;
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                image.close();
            }
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.normalizedDomains = null;
        this.validPaths = null;
    }

    private boolean matchesPath(class_2960 location) {
        if (!MindfulDarkness.CONFIG.getHolder(ClientConfig.class).isAvailable()) {
            return false;
        }
        return ColorChangingResourceHandler.matchesPath(this.getNormalizedDomains(), this.getValidPaths(), location);
    }

    private synchronized List<String> getNormalizedDomains() {
        List<String> normalizedDomains = this.normalizedDomains;
        if (normalizedDomains == null) {
            List<String> paths = ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).paths;
            this.normalizedDomains = normalizedDomains = ColorChangingResourceHandler.compileNormalizedDomains(paths);
        }
        return normalizedDomains;
    }

    private synchronized List<Function<String, Boolean>> getValidPaths() {
        List<Function<String, Boolean>> validPaths = this.validPaths;
        if (validPaths == null) {
            List<String> paths = ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).paths;
            this.validPaths = validPaths = ColorChangingResourceHandler.compileValidPaths(paths);
        }
        return validPaths;
    }

    private static List<String> compileNormalizedDomains(List<String> paths) {
        ArrayList normalized = Lists.newArrayList();
        block0: for (String path : paths) {
            if (path.startsWith("!")) continue;
            if ((path = path.replaceAll(".+:", "")).matches(".+/(.+\\.\\w+|\\*(\\.\\w+)?)")) {
                path = path.substring(0, path.lastIndexOf("/"));
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.isEmpty()) continue;
            if (path.matches("\\*(\\.\\w+)?")) {
                return List.of("");
            }
            ListIterator<String> iterator = normalized.listIterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                String prefix = StringUtils.getCommonPrefix((String[])new String[]{s, path});
                if (prefix.isEmpty() || prefix.length() < s.length() && s.charAt(prefix.length()) != '/') continue;
                iterator.set(prefix);
                continue block0;
            }
            normalized.add(path);
        }
        return normalized;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Function<String, Boolean>> compileValidPaths(List<String> paths) {
        ArrayList pathFilters = Lists.newArrayList();
        for (String string : paths) {
            void var3_8;
            void var3_6;
            boolean inverse = string.startsWith("!");
            if (inverse) {
                String string2 = string.substring(1);
            }
            if (!var3_6.contains(":")) {
                String string3 = "[a-z0-9_.-]+:" + (String)var3_6;
            }
            String string4 = var3_8.replaceAll("\\*", "[a-z0-9_.-]+").replaceAll("\\.", "\\\\.");
            String filter = "^" + string4 + "$";
            pathFilters.add(s -> s.matches(filter) ? Boolean.valueOf(!inverse) : null);
        }
        Collections.reverse(pathFilters);
        return pathFilters;
    }

    private static boolean matchesPath(List<String> domains, List<Function<String, Boolean>> filters, class_2960 resourceLocation) {
        String path = resourceLocation.toString();
        if (!path.endsWith(".png")) {
            return false;
        }
        for (String domain : domains) {
            if (!resourceLocation.method_12832().startsWith(domain)) continue;
            for (Function<String, Boolean> filter : filters) {
                Boolean result = filter.apply(path);
                if (result == null) continue;
                return result;
            }
            return false;
        }
        return false;
    }
}

